/* Data */
#define STOP                        0x00000000
#define POINTS                      0x00000001
#define LINES                       0x00000002
#define LINE_LOOP                   0x00000003
#define LINE_STRIP                  0x00000004
#define TRIANGLES                   0x00000005
#define TRIANGLE_STRIP              0x00000006
#define TRIANGLE_FAN                0x00000007
#define QUADS                       0x00000008
#define QUAD_STRIP                  0x00000009
#define POLYGON                     0x0000000A

/* Boolean */
#define FALSE                       0
#define TRUE                        1

/* Objects */
#define NV_MEMORY_TO_MEMORY_FORMAT			0x00000039
#define NV_MEMORY_TO_MEMORY_FORMAT_NOP			0x00000100
#define NV_MEMORY_TO_MEMORY_FORMAT_NOTIFY		0x00000104
#define NV_MEMORY_TO_MEMORY_FORMAT_DMA_NOTIFY		0x00000180
#define NV_MEMORY_TO_MEMORY_FORMAT_OBJECT_IN		0x00000184
#define NV_MEMORY_TO_MEMORY_FORMAT_OBJECT_OUT		0x00000188
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK0			0x00000200
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK1			0x0000021c
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK2			0x00000220
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK3			0x00000224
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK4			0x00000228
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK5			0x0000022c
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK6			0x00000230
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK7			0x00000234
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK8			0x00000238
#define NV_MEMORY_TO_MEMORY_FORMAT_UNK9			0x0000023c
#define NV_MEMORY_TO_MEMORY_FORMAT_OFFSET_IN		0x0000030C
#define NV_MEMORY_TO_MEMORY_FORMAT_OFFSET_OUT		0x00000310
#define NV_MEMORY_TO_MEMORY_FORMAT_PITCH_IN		0x00000314
#define NV_MEMORY_TO_MEMORY_FORMAT_PITCH_OUT		0x00000318
#define NV_MEMORY_TO_MEMORY_FORMAT_LINE_LENGTH_IN	0x0000031C
#define NV_MEMORY_TO_MEMORY_FORMAT_LINE_COUNT		0x00000320
#define NV_MEMORY_TO_MEMORY_FORMAT_FORMAT		0x00000324
#define NV_MEMORY_TO_MEMORY_FORMAT_BUF_NOTIFY		0x00000328


#define NV04_GDI_RECTANGLE_TEXT				0x0000004a

#define NV04_GDI_RECTANGLE_TEXT_SET_DMA_NOTIFY		0x00000180
#define NV04_GDI_RECTANGLE_TEXT_PATTERN			0x00000188
#define NV04_GDI_RECTANGLE_TEXT_ROP5			0x0000018c
#define NV04_GDI_RECTANGLE_TEXT_SURFACE			0x00000198

#define NV04_GDI_RECTANGLE_TEXT_OPERATION		0x000002fc
#define NV04_GDI_RECTANGLE_TEXT_FORMAT			0x00000300

#define NV04_GDI_RECTANGLE_TEXT_SOLID_COLOR		0x000003fc
#define NV04_GDI_RECTANGLE_TEXT_SOLID_RECTS(i)	(0x00000400+(i)*8)
#define NV04_GDI_RECTANGLE_TEXT_SOLID_RECTS__SIZE 32
#define NV04_GDI_RECTANGLE_TEXT_SOLID_RECTS_Y	15:0
#define NV04_GDI_RECTANGLE_TEXT_SOLID_RECTS_X	31:16
#define NV04_GDI_RECTANGLE_TEXT_SOLID_RECTS_HEIGHT	47:32
#define NV04_GDI_RECTANGLE_TEXT_SOLID_RECTS_WIDTH	63:48

#define NV04_GDI_RECTANGLE_TEXT_BLOCK_LEVEL1_TL		0x000005f4
#define NV04_GDI_RECTANGLE_TEXT_BLOCK_LEVEL1_BR		0x000005f8
#define NV04_GDI_RECTANGLE_TEXT_FILL_VALUE		0x000005fc
#define NV04_GDI_RECTANGLE_TEXT_BLOCK_LEVEL2_TL		0x00000600
#define NV04_GDI_RECTANGLE_TEXT_BLOCK_LEVEL2_BR		0x00000604

#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_CLIP    0x000007ec
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_CLIP_POINT0_X     15:0
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_CLIP_POINT0_Y     31:16
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_CLIP_POINT1_X     47:32
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_CLIP_POINT1_Y     63:48
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_COLOR         0x000007f4
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_SIZE          0x000007f8
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_SIZE_WIDTH    15:0
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_SIZE_HEIGHT   31:16
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_POINT         0x000007fc
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_POINT_X       15:0
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_POINT_Y       31:16
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_DATA(i)       (0x00000800+(i)*4)
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_ONE_COLOR_DATA__SIZE    128

#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_CLIP           0x00000be4
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_CLIP_POINT0_X  15:0
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_CLIP_POINT0_Y  31:16
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_CLIP_POINT1_X  47:32
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_CLIP_POINT1_Y  63:48
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_COLOR_0        0x00000bec
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_COLOR_1        0x00000bfc
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_SIZE_IN        0x00000bf4
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_SIZE_IN_WIDTH  15:0
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_SIZE_IN_HEIGHT 31:16
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_SIZE_OUT       0x00000bf8
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_SIZE_OUT_WIDTH 15:0
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_SIZE_OUT_HEIGH 31:16
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_POINT          0x00000bfc
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_POINT_X        15:0
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_POINT_Y        31:16
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_DATA(i)        (0x00000c00+(i)*4)
#define NV04_GDI_RECTANGLE_TEXT_EXPAND_TWO_COLOR_DATA__SIZE     128


#define NV04_CONTEXT_SURFACES_3D			0x00000053
#define NV04_CONTEXT_SURFACES_3D_DMA_NOTIFY		0x00000180
#define NV04_CONTEXT_SURFACES_3D_DMA_COLOR		0x00000184
#define NV04_CONTEXT_SURFACES_3D_DMA_ZETA		0x00000188
#define NV04_CONTEXT_SURFACES_3D_CLIP_HORIZONTAL	0x000002F8
#define NV04_CONTEXT_SURFACES_3D_CLIP_HORIZONTAL_X	15:0
#define NV04_CONTEXT_SURFACES_3D_CLIP_HORIZONTAL_WIDTH	31:16
#define NV04_CONTEXT_SURFACES_3D_CLIP_VERTICAL		0x000002FC
#define NV04_CONTEXT_SURFACES_3D_CLIP_VERTICAL_Y	15:0
#define NV04_CONTEXT_SURFACES_3D_CLIP_VERTICAL_HEIGHT	31:16
#define NV04_CONTEXT_SURFACES_3D_FORMAT			0x00000300
#define NV04_CONTEXT_SURFACES_3D_FORMAT_COLOR		7:0
#define NV04_CONTEXT_SURFACES_3D_FORMAT_TYPE		15:8
#define NV04_CONTEXT_SURFACES_3D_FORMAT_WIDTH		23:16 // also I get zeroes here
#define NV04_CONTEXT_SURFACES_3D_FORMAT_HEIGHT		31:24 // see above
#define NV04_CONTEXT_SURFACES_3D_CLIP_SIZE		0x00000304
#define NV04_CONTEXT_SURFACES_3D_CLIP_SIZE_WIDTH	15:0
#define NV04_CONTEXT_SURFACES_3D_CLIP_SIZE_HEIGHT	31:15
#define NV04_CONTEXT_SURFACES_3D_PITCH			0x00000308
#define NV04_CONTEXT_SURFACES_3D_PITCH_COLOR		15:0
#define NV04_CONTEXT_SURFACES_3D_PITCH_ZETA		31:16
#define NV04_CONTEXT_SURFACES_3D_OFFSET_COLOR		0x0000030c
#define NV04_CONTEXT_SURFACES_3D_OFFSET_ZETA		0x00000310


#define NV04_DX5_TEXTURED_TRIANGLE			0x00000054

#define NV04_DX5_TEXTURED_TRIANGLE_NOP			0x00000100
#define NV04_DX5_TEXTURED_TRIANGLE_NOTIFY		0x00000104

#define NV04_DX5_TEXTURED_TRIANGLE_DMA_NOTIFY		0x00000180
#define NV04_DX5_TEXTURED_TRIANGLE_DMA_1		0x00000184
#define NV04_DX5_TEXTURED_TRIANGLE_DMA_2		0x00000188
#define NV04_DX5_TEXTURED_TRIANGLE_SURFACE		0x0000018c

#define NV04_DX5_TEXTURED_TRIANGLE_COLOR_KEY		0x00000300
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_OFFSET	0x00000304
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FORMAT	0x00000308
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FORMAT_WRAP_T	30:28
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FORMAT_WRAP_S	26:24
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FORMAT_SIZE_V	23:20
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FORMAT_SIZE_U	19:16
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FORMAT_MIPMAPS	15:12
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FORMAT_COLOR		11:8
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FILTER	0x0000030C
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FILTER_MAG	30:28
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FILTER_MIN	26:24
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FILTER_LODBIAS	23:16
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_FILTER_DITHER	15:15
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND		0x00000310
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_DST		31:28
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_SRC		27:24
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_ENABLE		20:20
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_FOG		16:16
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_SPECULAR	12:12
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_TEXTUREPERSPECTIVE	8:8
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_SHADEMODE	7:6
#define NV04_DX5_TEXTURED_TRIANGLE_BLEND_TEXTURE	3:0
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL		0x00000314
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ALPHAREF	7:0
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ALPHAFUNC	11:8
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ALPHATEST	12:12
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ZENABLE	14:14
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ZFUNC	19:16
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_CULLMODE	21:20
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_DITHER	22:22
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ZPERSPECTIVE	23:23
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ZWRITE	24:24
#define NV04_DX5_TEXTURED_TRIANGLE_CONTROL_ZFORMAT	31:30
#define NV04_DX5_TEXTURED_TRIANGLE_FOG_COLOR		0x00000318


#define NV04_DX5_TEXTURED_TRIANGLE_TLVERTEX_SX(i)	(0x00000400 + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_TLVERTEX_SX__SIZE		16
#define NV04_DX5_TEXTURED_TRIANGLE_TLVERTEX_SY(i)	(0x00000404 + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_TLVERTEX_SY__SIZE		16
#define NV04_DX5_TEXTURED_TRIANGLE_TLVERTEX_SZ(i)	(0x00000408 + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_TLVERTEX_SZ__SIZE		16
#define NV04_DX5_TEXTURED_TRIANGLE_INV_W(i)		(0x0000040C + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_INV_W__SIZE			16
#define NV04_DX5_TEXTURED_TRIANGLE_COLOR(i)		(0x00000410 + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_COLOR__SIZE			16
#define NV04_DX5_TEXTURED_TRIANGLE_SPECULAR(i)		(0x00000414 + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_SPECULAR__SIZE		16
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_S(i)		(0x00000418 + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_S__SIZE		16
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_T(i)		(0x0000041C + 0x20 * i)
#define NV04_DX5_TEXTURED_TRIANGLE_TEXTURE_T__SIZE		16

#define NV04_DX5_TEXTURED_TRIANGLE_DRAW			0x00000600
#define NV04_DX5_TEXTURED_TRIANGLE_DRAW_V0		  3:0
#define NV04_DX5_TEXTURED_TRIANGLE_DRAW_V1		  7:4
#define NV04_DX5_TEXTURED_TRIANGLE_DRAW_V2		 11:8
#define NV04_DX5_TEXTURED_TRIANGLE_DRAW_V3		15:12
#define NV04_DX5_TEXTURED_TRIANGLE_DRAW_V4		19:16
#define NV04_DX5_TEXTURED_TRIANGLE_DRAW_V5		23:20

#define NV04_DX6_MULTITEX_TRIANGLE			0x00000055

#define NV04_DX6_MULTITEX_TRIANGLE_NOP			0x00000100
#define NV04_DX6_MULTITEX_TRIANGLE_NOTIFY		0x00000104

#define NV04_DX6_MULTITEX_TRIANGLE_DMA_NOTIFY		0x00000180
#define NV04_DX6_MULTITEX_TRIANGLE_DMA_1		0x00000184
#define NV04_DX6_MULTITEX_TRIANGLE_DMA_2		0x00000188
#define NV04_DX6_MULTITEX_TRIANGLE_SURFACE		0x0000018c

#define NV04_DX6_MULTITEX_TRIANGLE_OFFSET0		0x00000308
#define NV04_DX6_MULTITEX_TRIANGLE_OFFSET1		0x0000030c
#define NV04_DX6_MULTITEX_TRIANGLE_FORMAT0		0x00000310
#define NV04_DX6_MULTITEX_TRIANGLE_FORMAT1		0x00000314
#define NV04_DX6_MULTITEX_TRIANGLE_FILTER0		0x00000318
#define NV04_DX6_MULTITEX_TRIANGLE_FILTER1		0x0000031c
#define NV04_DX6_MULTITEX_TRIANGLE_COMBINE_0_ALPHA	0x00000320
#define NV04_DX6_MULTITEX_TRIANGLE_COMBINE_0_COLOR	0x00000324
#define NV04_DX6_MULTITEX_TRIANGLE_COMBINE_1_ALPHA	0x0000032c
#define NV04_DX6_MULTITEX_TRIANGLE_COMBINE_1_COLOR	0x00000330
#define NV04_DX6_MULTITEX_TRIANGLE_COMBINE_FACTOR	0x00000334

#define NV04_DX6_MULTITEX_TRIANGLE_BLEND		0x00000338
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL0		0x0000033c
// control0 is more or less the same as 0x54 (dx5_tri)_control
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL0_R_WRITE	27:27
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL0_G_WRITE	28:28
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL0_B_WRITE	29:29
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL0_A_WRITE	26:26
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL0_S_WRITE	25:25
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL1		0x00000340
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL1_STENCILENABLE 0:0
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL1_STENCILFUNC	7:4
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL1_STENCILREF	15:8
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL1_STENCIL_MASK_READ	23:16
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL1_STENCIL_MASK_WRITE	31:24
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL2		0x00000344
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL2_STENCIL_FAIL	3:0
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL2_STENCIL_ZFAIL	7:4
#define NV04_DX6_MULTITEX_TRIANGLE_CONTROL2_STENCIL_ZPASS	11:8
#define NV04_DX6_MULTITEX_TRIANGLE_FOG_COLOR		0x00000348

#define NV04_DX6_MULTITEX_TRIANGLE_TLVERTEX_SX(i)	(0x00000400 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_TLVERTEX_SX__SIZE		8
#define NV04_DX6_MULTITEX_TRIANGLE_TLVERTEX_SY(i)	(0x00000404 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_TLVERTEX_SY__SIZE		8
#define NV04_DX6_MULTITEX_TRIANGLE_TLVERTEX_SZ(i)	(0x00000408 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_TLVERTEX_SZ__SIZE		8
#define NV04_DX6_MULTITEX_TRIANGLE_INV_W(i)		(0x0000040C + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_INV_W__SIZE			8
#define NV04_DX6_MULTITEX_TRIANGLE_COLOR(i)		(0x00000410 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_COLOR__SIZE			8
#define NV04_DX6_MULTITEX_TRIANGLE_SPECULAR(i)		(0x00000414 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_SPECULAR__SIZE		8
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE0_S(i)	(0x00000418 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE0_S__SIZE		8
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE0_T(i)	(0x0000041C + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE0_T__SIZE		8
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE1_S(i)	(0x00000420 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE1_S__SIZE		8
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE1_T(i)	(0x00000424 + 0x28 * i)
#define NV04_DX6_MULTITEX_TRIANGLE_TEXTURE1_T__SIZE		8

#define NV04_DX6_MULTITEX_TRIANGLE_DRAW			0x00000540
#define NV04_DX6_MULTITEX_TRIANGLE_DRAW_V0		  3:0
#define NV04_DX6_MULTITEX_TRIANGLE_DRAW_V1		  7:4
#define NV04_DX6_MULTITEX_TRIANGLE_DRAW_V2		 11:8
#define NV04_DX6_MULTITEX_TRIANGLE_DRAW_V3		15:12
#define NV04_DX6_MULTITEX_TRIANGLE_DRAW_V4		19:16
#define NV04_DX6_MULTITEX_TRIANGLE_DRAW_V5		23:20

#define NV04_COLOR_KEY					0x00000057
#define NV04_COLOR_KEY_SET_DMA_NOTIFY			0x00000180
#define NV04_COLOR_KEY_FORMAT				0x00000300
#define NV04_COLOR_KEY_VALUE				0x00000304

#define NV04_SOLID_LINE					0x0000005c
#define NV04_SOLID_LINE_CLIP_RECTANGLE			0x00000184
#define NV04_SOLID_LINE_PATTERN				0x00000188
#define NV04_SOLID_LINE_ROP				0x0000018c
#define NV04_SOLID_LINE_SURFACE				0x00000198
#define NV04_SOLID_LINE_OPERATION			0x000002FC
#define NV04_SOLID_LINE_COLOR_FORMAT			0x00000300
#define NV04_SOLID_LINE_COLOR_VALUE			0x00000304
#define NV04_SOLID_LINE_START				0x00000400
#define NV04_SOLID_LINE_START_X				15:0
#define NV04_SOLID_LINE_START_Y				31:16
#define NV04_SOLID_LINE_END				0x00000400
#define NV04_SOLID_LINE_END_X				15:0
#define NV04_SOLID_LINE_END_Y				31:16

#define NV04_UNK005E					0x0000005e
#define NV04_UNK005E_SET_SURFACE			0x00000198
#define NV04_UNK005E_UNK02fc				0x000002fc
#define NV04_UNK005E_UNK0300				0x00000300
#define NV04_UNK005E_COUNTER				0x00000304

#define NV_IMAGE_FROM_CPU				0x00000061
#define NV_IMAGE_FROM_CPU_DMA_NOTIFY			0x00000180
#define NV_IMAGE_FROM_CPU_CLIP_RECTANGLE		0x00000188
#define NV_IMAGE_FROM_CPU_PATTERN			0x0000018C
#define NV_IMAGE_FROM_CPU_ROP				0x00000190
#define NV_IMAGE_FROM_CPU_SURFACE			0x0000019C
#define NV_IMAGE_FROM_CPU_OPERATION			0x000002FC
#define NV_IMAGE_FROM_CPU_FORMAT			0x00000300

// XXX: the hw context holds type = 061 !
#define NV05_IMAGE_FROM_CPU				0x00000065

#define NV05_IMAGE_FROM_CPU_DMA_NOTIFY			0x00000180
#define NV05_IMAGE_FROM_CPU_CLIP_RECTANGLE		0x00000188
#define NV05_IMAGE_FROM_CPU_PATTERN			0x0000018C
#define NV05_IMAGE_FROM_CPU_ROP				0x00000190
#define NV05_IMAGE_FROM_CPU_SURFACE			0x0000019C
#define NV05_IMAGE_FROM_CPU_OPERATION			0x000002FC
#define NV05_IMAGE_FROM_CPU_FORMAT			0x00000300
#define NV05_IMAGE_FROM_CPU_POINT			0x00000304
#define NV05_IMAGE_FROM_CPU_POINT_X			15:0
#define NV05_IMAGE_FROM_CPU_POINT_Y			31:16
#define NV05_IMAGE_FROM_CPU_SIZE_OUT			0x00000308
#define NV05_IMAGE_FROM_CPU_SIZE_OUT_WIDTH		15:0
#define NV05_IMAGE_FROM_CPU_SIZE_OUT_HEIGHT		31:16
#define NV05_IMAGE_FROM_CPU_SIZE_IN			0x0000030c
#define NV05_IMAGE_FROM_CPU_SIZE_IN_WIDTH		15:0
#define NV05_IMAGE_FROM_CPU_SIZE_IN_HEIGHT		31:16
#define NV05_IMAGE_FROM_CPU_COLOR(i)			(0x000000400 + 4 * i)
#define NV05_IMAGE_FROM_CPU_COLOR__SIZE			1792

/*
NV10_TCL_PRIMITIVE_3D unknown commands
           values
0120       1       (nv11+) set to 0 on init context, correspond to nv10_image_blit[0x120]
0124       1       (nv11+) set to 1 on init context, correspond to nv10_image_blit[0x124]
0128       1       (nv11+) set to 2 on init context, correspond to nv10_image_blit[0x128]
0258-025c  2       (nv17+) set to 1 on init context
0290       1               set to 0x00100001 on init context
02b4       1               set to 0 before setting the clip_horiz,vert values
03f0       1       (nv15+) set to 3 when fsaa is enabled, renders then set to 2 for swap buffers
03f4       1               set to 0 on init context
03f8       1       (nv17+) set to 0 on init context
03fc       1       (nv17+) set to 0xff on init context if double buffer, 0 otherwise
0d74       1       (nv17+) set to 0 on init context
0d84       1       (nv17+) set to 3 on init context
*/

#define NV10_TCL_PRIMITIVE_3D				0x00000056
#define NV11_TCL_PRIMITIVE_3D				0x00000096
#define NV17_TCL_PRIMITIVE_3D				0x00000099

#define NV10_TCL_PRIMITIVE_3D_NOP			0x00000100
#define NV10_TCL_PRIMITIVE_3D_NOTIFY			0x00000104
//							0x00000120
//							0x00000124
//							0x00000128
#define NV10_TCL_PRIMITIVE_3D_SET_DMA_NOTIFY		0x00000180
#define NV10_TCL_PRIMITIVE_3D_SET_DMA_IN_MEMORY0	0x00000184
#define NV10_TCL_PRIMITIVE_3D_SET_DMA_IN_MEMORY1	0x00000188
#define NV10_TCL_PRIMITIVE_3D_SET_DISPLAY_LIST		0x0000018c
#define NV10_TCL_PRIMITIVE_3D_SET_DMA_IN_MEMORY2	0x00000194
#define NV10_TCL_PRIMITIVE_3D_SET_DMA_IN_MEMORY3	0x00000198
#define NV17_TCL_PRIMITIVE_3D_SET_DMA_IN_MEMORY4	0x000001ac
#define NV17_TCL_PRIMITIVE_3D_SET_DMA_IN_MEMORY5	0x000001b0
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_HORIZ		0x00000200
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_VERT		0x00000204
#define NV10_TCL_PRIMITIVE_3D_BUFFER_FORMAT		0x00000208
#define NV10_TCL_PRIMITIVE_3D_BUFFER_PITCH		0x0000020c
#define NV10_TCL_PRIMITIVE_3D_COLOR_OFFSET		0x00000210
#define NV10_TCL_PRIMITIVE_3D_DEPTH_OFFSET		0x00000214
#define NV10_TCL_PRIMITIVE_3D_TX_OFFSET(n)		(0x00000218+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_TX_FORMAT(n)		(0x00000220+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_TX_ENABLE(n)		(0x00000228+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_TX_NPOT_PITCH(n)		(0x00000230+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_TX_NPOT_SIZE(n)		(0x00000240+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_TX_FILTER(n)		(0x00000248+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_TX_PALETTE_OFFSET(n)	(0x00000250+(n<<2))
//							0x00000258
//							0x0000025c
#define NV10_TCL_PRIMITIVE_3D_RC_IN_ALPHA(n)		(0x00000260+(n<<2))	/* input combiners, portion alpha */
#define NV10_TCL_PRIMITIVE_3D_RC_IN_RGB(n)		(0x00000268+(n<<2))	/* input combiners, portion rgb */
#define NV10_TCL_PRIMITIVE_3D_RC_COLOR0			0x00000270		/* combiners, constant colors */
#define NV10_TCL_PRIMITIVE_3D_RC_COLOR1			0x00000274
#define NV10_TCL_PRIMITIVE_3D_RC_OUT_ALPHA(n)		(0x00000278+(n<<2))	/* output combiners, portion alpha */
#define NV10_TCL_PRIMITIVE_3D_RC_OUT_RGB(n)		(0x00000280+(n<<2))	/* output combiners, portion rgb */
#define NV10_TCL_PRIMITIVE_3D_RC_FINAL0			0x00000288		/* final combiner, variables A-D */
#define NV10_TCL_PRIMITIVE_3D_RC_FINAL1			0x0000028c		/* final combiner, variables E-G */
//							0x00000290
#define NV10_TCL_PRIMITIVE_3D_LIGHT_MODEL		0x00000294
#define NV10_TCL_PRIMITIVE_3D_COLOR_MATERIAL_ENABLE	0x00000298
#define NV10_TCL_PRIMITIVE_3D_FOG_MODE			0x0000029c
#define NV10_TCL_PRIMITIVE_3D_FOG_COORD_DIST		0x000002a0
#define NV10_TCL_PRIMITIVE_3D_FOG_ENABLE		0x000002a4
#define NV10_TCL_PRIMITIVE_3D_FOG_COLOR			0x000002a8
//							0x000002b4
#define NV17_TCL_PRIMITIVE_3D_COLOR_MASK_ENABLE		0x000002bc
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_CLIP_HORIZ(n)	(0x000002c0+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_CLIP_VERT(n)	(0x000002e0+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_ALPHA_FUNC_ENABLE		0x00000300
#define NV10_TCL_PRIMITIVE_3D_BLEND_FUNC_ENABLE		0x00000304
#define NV10_TCL_PRIMITIVE_3D_CULL_FACE_ENABLE		0x00000308
#define NV10_TCL_PRIMITIVE_3D_DEPTH_TEST_ENABLE		0x0000030c
#define NV10_TCL_PRIMITIVE_3D_DITHER_ENABLE		0x00000310
#define NV10_TCL_PRIMITIVE_3D_LIGHTING_ENABLE		0x00000314
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETERS_ENABLE	0x00000318
#define NV10_TCL_PRIMITIVE_3D_POINT_SMOOTH_ENABLE	0x0000031c
#define NV10_TCL_PRIMITIVE_3D_LINE_SMOOTH_ENABLE	0x00000320
#define NV10_TCL_PRIMITIVE_3D_POLYGON_SMOOTH_ENABLE	0x00000324
#define NV10_TCL_PRIMITIVE_3D_VERTEX_WEIGHT_ENABLE	0x00000328
#define NV10_TCL_PRIMITIVE_3D_STENCIL_ENABLE		0x0000032c
#define NV10_TCL_PRIMITIVE_3D_POLYGON_OFFSET_POINT_ENABLE	0x00000330
#define NV10_TCL_PRIMITIVE_3D_POLYGON_OFFSET_LINE_ENABLE	0x00000334
#define NV10_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FILL_ENABLE	0x00000338
#define NV10_TCL_PRIMITIVE_3D_ALPHA_FUNC_FUNC		0x0000033c
#define NV10_TCL_PRIMITIVE_3D_ALPHA_FUNC_REF		0x00000340
#define NV10_TCL_PRIMITIVE_3D_BLEND_FUNC_SRC		0x00000344
#define NV10_TCL_PRIMITIVE_3D_BLEND_FUNC_DST		0x00000348
#define NV10_TCL_PRIMITIVE_3D_BLEND_COLOR		0x0000034c
#define NV10_TCL_PRIMITIVE_3D_BLEND_EQUATION		0x00000350
#define NV10_TCL_PRIMITIVE_3D_DEPTH_FUNC		0x00000354
#define NV10_TCL_PRIMITIVE_3D_COLOR_MASK		0x00000358
#define NV10_TCL_PRIMITIVE_3D_DEPTH_WRITE_ENABLE	0x0000035c
#define NV10_TCL_PRIMITIVE_3D_STENCIL_MASK		0x00000360
#define NV10_TCL_PRIMITIVE_3D_STENCIL_FUNC_FUNC		0x00000364
#define NV10_TCL_PRIMITIVE_3D_STENCIL_FUNC_REF		0x00000368
#define NV10_TCL_PRIMITIVE_3D_STENCIL_FUNC_MASK		0x0000036c
#define NV10_TCL_PRIMITIVE_3D_STENCIL_OP_FAIL		0x00000370
#define NV10_TCL_PRIMITIVE_3D_STENCIL_OP_ZFAIL		0x00000374
#define NV10_TCL_PRIMITIVE_3D_STENCIL_OP_ZPASS		0x00000378
#define NV10_TCL_PRIMITIVE_3D_SHADE_MODEL		0x0000037c
#define NV10_TCL_PRIMITIVE_3D_LINE_WIDTH		0x00000380	/* 8.0 * line_width */
#define NV10_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FACTOR	0x00000384
#define NV10_TCL_PRIMITIVE_3D_POLYGON_OFFSET_UNITS	0x00000388
#define NV10_TCL_PRIMITIVE_3D_POLYGON_MODE_FRONT	0x0000038c
#define NV10_TCL_PRIMITIVE_3D_POLYGON_MODE_BACK		0x00000390
#define NV10_TCL_PRIMITIVE_3D_DEPTH_RANGE_NEAR		0x00000394	/* near * 16777216.0 */
#define NV10_TCL_PRIMITIVE_3D_DEPTH_RANGE_FAR		0x00000398	/* far * 16777216.0 */
#define NV10_TCL_PRIMITIVE_3D_CULL_FACE			0x0000039c
#define NV10_TCL_PRIMITIVE_3D_FRONT_FACE		0x000003a0
#define NV10_TCL_PRIMITIVE_3D_NORMALIZE_ENABLE		0x000003a4
#define NV10_TCL_PRIMITIVE_3D_COLOR_MATERIAL_R		0x000003a8
#define NV10_TCL_PRIMITIVE_3D_COLOR_MATERIAL_G		0x000003ac
#define NV10_TCL_PRIMITIVE_3D_COLOR_MATERIAL_B		0x000003b0
#define NV10_TCL_PRIMITIVE_3D_COLOR_MATERIAL_A		0x000003b4
#define NV10_TCL_PRIMITIVE_3D_COLOR_CONTROL		0x000003b8
#define NV10_TCL_PRIMITIVE_3D_ENABLED_LIGHTS		0x000003bc
#define NV10_TCL_PRIMITIVE_3D_CLIP_PLANE_ENABLE(n)	(0x000003c0+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_CLIP_PLANE_ENABLE__SIZE		8
#define NV10_TCL_PRIMITIVE_3D_TX_MATRIX_ENABLE(n)	(0x000003e0+(n<<2))
#define NV10_TCL_PRIMITIVE_3D_VIEW_MATRIX_ENABLE	0x000003e8
#define NV10_TCL_PRIMITIVE_3D_POINT_SIZE		0x000003ec	/* 8.0 * point_size */
//							0x000003f0
//							0x000003f4
//							0x000003f8
//							0x000003fc
#define NV10_TCL_PRIMITIVE_3D_MODELVIEW0_MATRIX		0x00000400
#define NV10_TCL_PRIMITIVE_3D_MODELVIEW1_MATRIX		0x00000440
#define NV10_TCL_PRIMITIVE_3D_INVERSE_MODELVIEW0_MATRIX	0x00000480
#define NV10_TCL_PRIMITIVE_3D_INVERSE_MODELVIEW1_MATRIX	0x000004c0
#define NV10_TCL_PRIMITIVE_3D_PROJECTION_MATRIX		0x00000500
#define NV10_TCL_PRIMITIVE_3D_TX_MATRIX(n)		(0x00000540+(n<<6))
#define NV10_TCL_PRIMITIVE_3D_CLIP_PLANE_A(n)		(0x00000600+(n<<4))
#define NV10_TCL_PRIMITIVE_3D_CLIP_PLANE_B(n)		(0x00000604+(n<<4))
#define NV10_TCL_PRIMITIVE_3D_CLIP_PLANE_C(n)		(0x00000608+(n<<4))
#define NV10_TCL_PRIMITIVE_3D_CLIP_PLANE_D(n)		(0x0000060c+(n<<4))
#define NV10_TCL_PRIMITIVE_3D_FOG_EQUATION_CONSTANT	0x00000680	/* 1.0+(end/(end-start)) */
#define NV10_TCL_PRIMITIVE_3D_FOG_EQUATION_LINEAR	0x00000684	/* -1.0/(end-start) */
#define NV10_TCL_PRIMITIVE_3D_FOG_EQUATION_QUADRATIC	0x00000688	/* 0.0 */
#define NV10_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_A	0x000006a0
#define NV10_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_B	0x000006a4
#define NV10_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_C	0x000006a8
#define NV10_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_D	0x000006ac
#define NV10_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_E	0x000006b0
#define NV10_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_F	0x000006b4
#define NV10_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_R	0x000006c4
#define NV10_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_G	0x000006c8
#define NV10_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_B	0x000006cc
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_SCALE_X		0x000006e8	/* unsure */
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_SCALE_Y		0x000006ec
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_SCALE_Z		0x000006f0
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_SCALE_W		0x000006f4
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_A		0x000006f8
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_B		0x000006fc
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_C		0x00000700
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_D		0x00000704
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_E		0x00000708
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_F		0x0000070c
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_G		0x00000710
#define NV10_TCL_PRIMITIVE_3D_POINT_PARAMETER_H		0x00000714
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_R(n)	(0x00000800+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_G(n)	(0x00000804+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_B(n)	(0x00000808+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_R(n)	(0x0000080c+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_G(n)	(0x00000810+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_B(n)	(0x00000814+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_R(n)	(0x00000818+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_G(n)	(0x0000081c+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_B(n)	(0x00000820+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_X(n)	(0x00000828+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_Y(n)	(0x0000082c+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_Z(n)	(0x00000830+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_X(n)	(0x00000834+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_Y(n)	(0x00000838+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_Z(n)	(0x0000083c+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_A(n)	(0x00000840+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_SPOT_EXPONENT(n)	(0x00000844+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_B(n)	(0x00000848+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_X(n)	(0x0000084c+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_Y(n)	(0x00000850+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_Z(n)	(0x00000854+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_C(n)	(0x00000858+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_POSITION_X(n)	(0x0000085c+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_POSITION_Y(n)	(0x00000860+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_POSITION_Z(n)	(0x00000864+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_CONSTANT_ATTENUATION(n)		(0x00000868+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_LINEAR_ATTENUATION(n)		(0x0000086c+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_LIGHT_QUADRATIC_ATTENUATION(n)		(0x00000870+(n<<7))
#define NV10_TCL_PRIMITIVE_3D_VERTEX_POS_3F_X		0x00000c00
#define NV10_TCL_PRIMITIVE_3D_VERTEX_POS_3F_Y		0x00000c04
#define NV10_TCL_PRIMITIVE_3D_VERTEX_POS_3F_Z		0x00000c08
#define NV10_TCL_PRIMITIVE_3D_VERTEX_POS_4F_X		0x00000c18
#define NV10_TCL_PRIMITIVE_3D_VERTEX_POS_4F_Y		0x00000c1c
#define NV10_TCL_PRIMITIVE_3D_VERTEX_POS_4F_Z		0x00000c20
#define NV10_TCL_PRIMITIVE_3D_VERTEX_POS_4F_W		0x00000c24
#define NV10_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_X		0x00000c30
#define NV10_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_Y		0x00000c34
#define NV10_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_Z		0x00000c38
#define NV10_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_XY		0x00000c40
#define NV10_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_Z		0x00000c44
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_4F_R		0x00000c50
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_4F_G		0x00000c54
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_4F_B		0x00000c58
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_4F_A		0x00000c5c
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_3F_R		0x00000c60
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_3F_G		0x00000c64
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_3F_B		0x00000c68
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL_4I		0x00000c6c
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_R		0x00000c80
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_G		0x00000c84
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_B		0x00000c88
#define NV10_TCL_PRIMITIVE_3D_VERTEX_COL2_3I		0x00000c8c
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_S		0x00000c90
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_T		0x00000c94
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_2I		0x00000c98
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_S		0x00000ca0
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_T		0x00000ca4
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_R		0x00000ca8
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_Q		0x00000cac
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_ST		0x00000cb0
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_RQ		0x00000cb4
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_S		0x00000cb8
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_T		0x00000cbc
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_2I		0x00000cc0
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_S		0x00000cc8
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_T		0x00000ccc
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_R		0x00000cd0
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_Q		0x00000cd4
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_ST		0x00000cd8
#define NV10_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_RQ		0x00000cdc
#define NV10_TCL_PRIMITIVE_3D_VERTEX_FOG_1F		0x00000ce0
#define NV10_TCL_PRIMITIVE_3D_VERTEX_WGH_1F		0x00000ce4
#define NV10_TCL_PRIMITIVE_3D_EDGEFLAG_ENABLE		0x00000cec
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_VALIDATE	0x00000cf0
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ATTR(i)		(0x00000d04+(i)*0x08)
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ATTR__SIZE		8
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_POS	0x00000d00
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_POS	0x00000d04
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_COL	0x00000d08
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_COL	0x00000d0c
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_COL2	0x00000d10
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_COL2	0x00000d14
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_TX0	0x00000d18
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_TX0	0x00000d1c
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_TX1	0x00000d20
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_TX1	0x00000d24
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_NOR	0x00000d28
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_NOR	0x00000d2c
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_WGH	0x00000d30
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_WGH	0x00000d34
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_OFFSET_FOG	0x00000d38
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_FORMAT_FOG	0x00000d3c
#define NV10_TCL_PRIMITIVE_3D_COLOR_LOGIC_OP_ENABLE	0x00000d40
#define NV10_TCL_PRIMITIVE_3D_COLOR_LOGIC_OP_OP		0x00000d44
#define NV17_TCL_PRIMITIVE_3D_LMA_DEPTH_BUFFER_PITCH	0x00000d5c	/* LMA_DEPTH is nv17 only */
#define NV17_TCL_PRIMITIVE_3D_LMA_DEPTH_BUFFER_OFFSET	0x00000d60
#define NV17_TCL_PRIMITIVE_3D_LMA_DEPTH_FILL_VALUE	0x00000d68
#define NV17_TCL_PRIMITIVE_3D_LMA_DEPTH_CLEAR_ENABLE	0x00000d6c
//							0x00000d74
//							0x00000d84
#define NV10_TCL_PRIMITIVE_3D_BEGIN_END			0x00000dfc
#define NV10_TCL_PRIMITIVE_3D_INDEX_DATA		0x00000e00
#define NV10_TCL_PRIMITIVE_3D_VERTEX_BUFFER_BEGIN_END	0x000013fc
#define NV10_TCL_PRIMITIVE_3D_VERTEX_BUFFER_DRAW_ARRAYS	0x00001400
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_X		0x00001638
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_Y		0x0000163c
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_Z		0x00001640
#define NV10_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_W		0x00001644
#define NV17_TCL_PRIMITIVE_3D_LMA_DEPTH_ENABLE		0x00001658
#define NV10_TCL_PRIMITIVE_3D_VERTEX_ARRAY_DATA		0x00001800


#define NV10_IMAGE_FROM_CPU				0x0000008a
#define NV10_IMAGE_FROM_CPU_SET_DMA_NOTIFY			0x00000180
#define NV10_IMAGE_FROM_CPU_SET_CONTEXT_CLIP_RECTANGLE	0x00000188
#define NV10_IMAGE_FROM_CPU_SET_IMAGE_PATTERN		0x0000018c
#define NV10_IMAGE_FROM_CPU_SET_RASTER_OP		0x00000190
#define NV10_IMAGE_FROM_CPU_SET_CONTEXT_SURFACES_2D	0x0000019c
#define NV10_IMAGE_FROM_CPU_OPERATION			0x000002fc
#define NV10_IMAGE_FROM_CPU_FORMAT			0x00000300
#define NV10_IMAGE_FROM_CPU_POINT			0x00000304
#define NV10_IMAGE_FROM_CPU_POINT_X			15:0
#define NV10_IMAGE_FROM_CPU_POINT_Y			31:16
#define NV10_IMAGE_FROM_CPU_SIZE_OUT			0x00000308
#define NV10_IMAGE_FROM_CPU_SIZE_OUT_WIDTH		15:0
#define NV10_IMAGE_FROM_CPU_SIZE_OUT_HEIGHT		31:16
#define NV10_IMAGE_FROM_CPU_SIZE_IN			0x0000030c
#define NV10_IMAGE_FROM_CPU_SIZE_IN_WIDTH		15:0
#define NV10_IMAGE_FROM_CPU_SIZE_IN_HEIGHT		31:16
#define NV10_IMAGE_FROM_CPU_HLINE			0x00000400


#define NV10_UNK0072				0x00000072
#define NV10_UNK0072_COUNTER			0x00000050
#define NV40_UNK0072_SET_OBJECT			0x00000060
#define NV40_UNK0072_UNK0			0x00000064
#define NV40_UNK0072_UNK1			0x0000006c
#define NV10_UNK0072_SET_DMA_NOTIFY		0x00000180


#define NV10_PRIMITIVE_2D				0x0000007b
#define NV10_PRIMITIVE_2D_SET_DMA_NOTIFY		0x00000180
#define NV10_PRIMITIVE_2D_SET_SURFACE			0x00000184
#define NV10_PRIMITIVE_2D_SET_FORMAT			0x00000300
#define NV10_PRIMITIVE_2D_SET_POINT			0x00000304
#define NV10_PRIMITIVE_2D_SET_POINT_X			15:0
#define NV10_PRIMITIVE_2D_SET_POINT_Y			31:16
#define NV10_PRIMITIVE_2D_SET_SIZE			0x00000308
#define NV10_PRIMITIVE_2D_SET_SIZE_WIDTH		15:0
#define NV10_PRIMITIVE_2D_SET_SIZE_HEIGHT		31:16
#define NV10_PRIMITIVE_2D_SET_CLIP_HORIZ		0x0000030c
#define NV10_PRIMITIVE_2D_SET_CLIP_HORIZ_WIDTH		31:16
#define NV10_PRIMITIVE_2D_SET_CLIP_HORIZ_X		15:0
#define NV10_PRIMITIVE_2D_SET_CLIP_VERT			0x00000310
#define NV10_PRIMITIVE_2D_SET_CLIP_VERT_HEIGHT		31:16
#define NV10_PRIMITIVE_2D_SET_CLIP_VERT_Y		15:0
#define NV10_PRIMITIVE_2D_SET_DATA(i)			(0x00000400 + (i)*4)
#define NV10_PRIMITIVE_2D_SET_DATA__SIZE		1792

#define NV01_CONTEXT_CLIP_RECTANGLE			0x00000019
#define NV01_CONTEXT_CLIP_RECTANGLE_SET_POINT		0x00000300
#define NV01_CONTEXT_CLIP_RECTANGLE_SET_POINT_X		15:0
#define NV01_CONTEXT_CLIP_RECTANGLE_SET_POINT_Y		31:16
#define NV01_CONTEXT_CLIP_RECTANGLE_SET_SIZE		0x00000304
#define NV01_CONTEXT_CLIP_RECTANGLE_SET_SIZE_WIDTH	15:0
#define NV01_CONTEXT_CLIP_RECTANGLE_SET_SIZE_HEIGHT	31:16

#define NV03_PRIMITIVE_RASTER_OP			0x00000043
#define NV03_PRIMITIVE_RASTER_OP_NOTIFY			0x00000100
#define NV03_PRIMITIVE_RASTER_OP_DMA_NOTIFY		0x00000180
#define NV03_PRIMITIVE_RASTER_OP_LOGIC_OP		0x00000300
#define NV03_PRIMITIVE_RASTER_OP_LOGIC_OP_CMD		7:4

#define NV04_CONTEXT_SURFACES_2D					0x00000042
#define NV04_CONTEXT_SURFACES_2D_NOTIFY		0x00000104
#define NV04_CONTEXT_SURFACES_2D_SET_DMA_NOTIFY		0x00000180
#define NV04_CONTEXT_SURFACES_2D_SET_DMA_IMAGE_SRC	0x00000184
#define NV04_CONTEXT_SURFACES_2D_SET_DMA_IMAGE_DST	0x00000188
#define NV04_CONTEXT_SURFACES_2D_FORMAT			0x00000300
#define NV04_CONTEXT_SURFACES_2D_FORMAT_COLOR		7:0
#define NV04_CONTEXT_SURFACES_2D_PITCH			0x00000304
#define NV04_CONTEXT_SURFACES_2D_PITCH_SRC		15:0
#define NV04_CONTEXT_SURFACES_2D_PITCH_DST		31:16
#define NV04_CONTEXT_SURFACES_2D_OFFSET_SRC		0x00000308
#define NV04_CONTEXT_SURFACES_2D_OFFSET_DST		0x0000030c

#define NV04_IMAGE_PATTERN				0x00000044
#define NV04_IMAGE_PATTERN_COLOR_FORMAT			0x00000300
#define NV04_IMAGE_PATTERN_MONO_FORMAT			0x00000304
#define NV04_IMAGE_PATTERN_SELECT			0x0000030c
#define NV04_IMAGE_PATTERN_MONOCHROME_SHAPE		0x00000308
#define NV04_IMAGE_PATTERN_MONOCHROME_COLOR0		0x00000310
#define NV04_IMAGE_PATTERN_MONOCHROME_COLOR1		0x00000314
#define NV04_IMAGE_PATTERN_MONOCHROME_PATTERN0		0x00000318
#define NV04_IMAGE_PATTERN_MONOCHROME_PATTERN1		0x0000031c

#define NV04_SWIZZLED_SURFACE				0x00000052
#define NV04_SWIZZLED_SURFACE_DMA_NOTIFY		0x00000180
#define NV04_SWIZZLED_SURFACE_DMA_IMAGE			0x00000184
#define NV04_SWIZZLED_SURFACE_FORMAT			0x00000300
#define NV04_SWIZZLED_SURFACE_FORMAT_HEIGHT		31:24
#define NV04_SWIZZLED_SURFACE_FORMAT_WIDTH		23:16
#define NV04_SWIZZLED_SURFACE_FORMAT_COLOR		15:0
#define NV04_SWIZZLED_SURFACE_OFFSET			0x00000304

#define NV_IMAGE_BLIT					0x0000005f

#define NV_IMAGE_BLIT_NOP				0x00000100
#define NV_IMAGE_BLIT_NOTIFY				0x00000104
#define NV_IMAGE_BLIT_DMA_NOTIFY			0x00000180
#define NV_IMAGE_BLIT_COLOR_KEY				0x00000184
#define NV_IMAGE_BLIT_CLIP_RECTANGLE			0x00000188
#define NV_IMAGE_BLIT_PATTERN				0x0000018c
#define NV_IMAGE_BLIT_ROP5				0x00000190
#define NV_IMAGE_BLIT_SURFACE				0x0000019c
#define NV_IMAGE_BLIT_OPERATION				0x000002FC
#define NV_IMAGE_BLIT_POINT_IN				0x00000300
#define NV_IMAGE_BLIT_POINT_IN_X			15:0
#define NV_IMAGE_BLIT_POINT_IN_Y			31:16
#define NV_IMAGE_BLIT_POINT_OUT				0x00000304
#define NV_IMAGE_BLIT_POINT_OUT_X			15:0
#define NV_IMAGE_BLIT_POINT_OUT_Y			31:16
#define NV_IMAGE_BLIT_SIZE				0x00000308
#define NV_IMAGE_BLIT_SIZE_WIDTH			15:0
#define NV_IMAGE_BLIT_SIZE_HEIGHT			31:16

#define NV10_CONTEXT_SURFACES_2D			0x00000062
#define NV10_CONTEXT_SURFACES_2D_SET_DMA_NOTIFY		0x00000180
#define NV10_CONTEXT_SURFACES_2D_SET_DMA_IN_MEMORY0	0x00000184
#define NV10_CONTEXT_SURFACES_2D_SET_DMA_IN_MEMORY1	0x00000188
#define NV10_CONTEXT_SURFACES_2D_FORMAT			0x00000300
#define NV10_CONTEXT_SURFACES_2D_FORMAT_COLOR		7:0
#define NV10_CONTEXT_SURFACES_2D_FORMAT_TYPE		15:7
#define NV10_CONTEXT_SURFACES_2D_FORMAT_WIDTH		23:16
#define NV10_CONTEXT_SURFACES_2D_FORMAT_HEIGHT		31:24
#define NV10_CONTEXT_SURFACES_2D_PITCH			0x00000304
#define NV10_CONTEXT_SURFACES_2D_PITCH_SRC		15:0
#define NV10_CONTEXT_SURFACES_2D_PITCH_DST		31:16
#define NV10_CONTEXT_SURFACES_2D_OFFSET_SRC		0x00000308
#define NV10_CONTEXT_SURFACES_2D_OFFSET_DST		0x0000030c

#define NV05_SCALED_IMAGE_FROM_MEMORY			0x00000063

#define NV05_SCALED_IMAGE_FROM_MEMORY_SURFACE		0x00000198
#define NV05_SCALED_IMAGE_FROM_MEMORY_COLOR_CONVERSION	0x000002fc
#define NV05_SCALED_IMAGE_FROM_MEMORY_OPERATION		0x00000304

#define NV05_SCALED_IMAGE_FROM_MEMORY_CLIP_POS		0x00000308
#define NV05_SCALED_IMAGE_FROM_MEMORY_CLIP_SIZE		0x0000030C
#define NV05_SCALED_IMAGE_FROM_MEMORY_OUT_POS		0x00000310
#define NV05_SCALED_IMAGE_FROM_MEMORY_OUT_SIZE		0x00000314
#define NV05_SCALED_IMAGE_FROM_MEMORY_DU_DX		0x00000318
#define NV05_SCALED_IMAGE_FROM_MEMORY_DV_DY		0x0000031C
#define NV05_SCALED_IMAGE_FROM_MEMORY_SIZE		0x00000400
#define NV05_SCALED_IMAGE_FROM_MEMORY_FORMAT		0x00000404
#define NV05_SCALED_IMAGE_FROM_MEMORY_OFFSET		0x00000408
#define NV05_SCALED_IMAGE_FROM_MEMORY_POINT		0x0000040C

#define NV04_SCALED_IMAGE_FROM_MEMORY			0x00000077
#define NV04_SCALED_IMAGE_FROM_MEMORY_DMA_NOTIFY	0x00000180
#define NV04_SCALED_IMAGE_FROM_MEMORY_DMA_IMAGE		0x00000184
#define NV04_SCALED_IMAGE_FROM_MEMORY_SURFACE		0x00000198

#define NV04_SCALED_IMAGE_FROM_MEMORY_COLOR_FORMAT	0x00000300
#define NV04_SCALED_IMAGE_FROM_MEMORY_OPERATION		0x00000304
#define NV04_SCALED_IMAGE_FROM_MEMORY_CLIP_POS		0x00000308
#define NV04_SCALED_IMAGE_FROM_MEMORY_CLIP_SIZE		0x0000030C
#define NV04_SCALED_IMAGE_FROM_MEMORY_OUT_POS		0x00000310
#define NV04_SCALED_IMAGE_FROM_MEMORY_OUT_SIZE		0x00000314
#define NV04_SCALED_IMAGE_FROM_MEMORY_DU_DX		0x00000318
#define NV04_SCALED_IMAGE_FROM_MEMORY_DV_DY		0x0000031C
#define NV04_SCALED_IMAGE_FROM_MEMORY_SIZE		0x00000400
#define NV04_SCALED_IMAGE_FROM_MEMORY_FORMAT		0x00000404
#define NV04_SCALED_IMAGE_FROM_MEMORY_OFFSET		0x00000408
#define NV04_SCALED_IMAGE_FROM_MEMORY_POINT		0x0000040C


#define NV10_VIDEO_DISPLAY				0x0000007c
#define NV10_VIDEO_DISPLAY_COUNTER			0x00000050
#define NV10_VIDEO_DISPLAY_SET_DMA_FROM_MEMORY		0x00000180
#define NV10_VIDEO_DISPLAY_SET_DMA_IN_MEMORY0		0x00000184
#define NV10_VIDEO_DISPLAY_SET_DMA_IN_MEMORY1		0x00000188
#define NV10_VIDEO_DISPLAY_SET_OBJECT3			0x0000019c
#define NV10_VIDEO_DISPLAY_UNK0250			0x00000250
#define NV10_VIDEO_DISPLAY_SIZE				0x000002f8
#define NV10_VIDEO_DISPLAY_OFFSET			0x00000300
#define NV10_VIDEO_DISPLAY_UNK0304			0x00000304


#define NV10_SCALED_IMAGE_FROM_MEMORY				0x00000089
#define NV10_SCALED_IMAGE_FROM_MEMORY_COUNTER			0x00000050
#define NV10_SCALED_IMAGE_FROM_MEMORY_SET_DMA_IN_MEMORY		0x00000184
#define NV10_SCALED_IMAGE_FROM_MEMORY_SET_IMAGE_PATTERN		0x00000188
#define NV10_SCALED_IMAGE_FROM_MEMORY_SET_RASTER_OP		0x0000018c
#define NV10_SCALED_IMAGE_FROM_MEMORY_SET_SURFACE		0x00000198	/* context_surfaces_2d or swizzled_surface */
#define NV10_SCALED_IMAGE_FROM_MEMORY_UNK02fc			0x000002fc
#define NV10_SCALED_IMAGE_FROM_MEMORY_UNK0300			0x00000300
#define NV10_SCALED_IMAGE_FROM_MEMORY_OPERATION			0x00000304
#define NV10_SCALED_IMAGE_FROM_MEMORY_CLIP_POS			0x00000308
#define NV10_SCALED_IMAGE_FROM_MEMORY_CLIP_SIZE			0x0000030C
#define NV10_SCALED_IMAGE_FROM_MEMORY_OUT_POS			0x00000310
#define NV10_SCALED_IMAGE_FROM_MEMORY_OUT_SIZE			0x00000314
#define NV10_SCALED_IMAGE_FROM_MEMORY_SIZE			0x00000400
#define NV10_SCALED_IMAGE_FROM_MEMORY_FORMAT			0x00000404
#define NV10_SCALED_IMAGE_FROM_MEMORY_OFFSET			0x00000408
#define NV10_SCALED_IMAGE_FROM_MEMORY_POINT			0x0000040C


#define NV10_IMAGE_BLIT					0x0000009f
#define NV10_IMAGE_BLIT_NOP				0x00000100
#define NV10_IMAGE_BLIT_NOTIFY				0x00000104
//							0x00000120	/* quadro, set to 0,1,2 */
//							0x00000124
//							0x00000128
#define NV10_IMAGE_BLIT_SET_DMA_NOTIFY			0x00000180
#define NV10_IMAGE_BLIT_SET_CONTEXT_CLIP_RECTANGLE	0x00000188
#define NV10_IMAGE_BLIT_SET_IMAGE_PATTERN		0x0000018c
#define NV10_IMAGE_BLIT_SET_RASTER_OP			0x00000190
#define NV10_IMAGE_BLIT_SET_CONTEXT_SURFACES_2D		0x0000019c
#define NV10_IMAGE_BLIT_SET_OPERATION			0x000002fc
#define NV10_IMAGE_BLIT_SET_POINT			0x00000300
#define NV10_IMAGE_BLIT_SET_POINT_X			15:0
#define NV10_IMAGE_BLIT_SET_POINT_Y			31:16
#define NV10_IMAGE_BLIT_SET_PITCH			0x00000304
#define NV10_IMAGE_BLIT_SET_PITCH_NEXT_LINE		31:16
#define NV10_IMAGE_BLIT_SET_SIZE			0x00000308
#define NV10_IMAGE_BLIT_SET_SIZE_WIDTH			15:0
#define NV10_IMAGE_BLIT_SET_SIZE_HEIGHT			31:16


/*
Unknown NV20 commands:

NV20_TCL_PRIMITIVE_3D      [0x1d78/4] = 0x00000001 | UNKNOWN = 00000001
	Appears always just after NV20_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FACTOR and
	_UNITS, and nowhere else. The parameter is always 0x1.
	FACTOR and UNITS are always followed by 0x1d78 in dumps nv20 nv25 nv25gl nv28pq,
	but there are exceptions in dumps nv28 and nv28sgl offset tests.
*/

#define NV20_SWIZZLED_SURFACE				0x0000009e
#define NV20_SWIZZLED_SURFACE_SET_OBJECT0		0x00000180
#define NV20_SWIZZLED_SURFACE_SET_OBJECT1		0x00000184
#define NV20_SWIZZLED_SURFACE_FORMAT			0x00000300
#define NV20_SWIZZLED_SURFACE_FORMAT_HEIGHT		31:24
#define NV20_SWIZZLED_SURFACE_FORMAT_WIDTH		23:16
#define NV20_SWIZZLED_SURFACE_FORMAT_COLOR		15:0
#define NV20_SWIZZLED_SURFACE_OFFSET			0x00000304

#define NV20_TCL_PRIMITIVE_SET_MAIN_OBJECT				0x00000000

#define NV20_TCL_PRIMITIVE_3D						0x00000097

#define NV20_TCL_PRIMITIVE_3D_NOP					0x00000100 //data=0
#define NV20_TCL_PRIMITIVE_3D_FIRE_INTERRUPT				0x00000100 //data=interrupt routine ID
#define NV20_TCL_PRIMITIVE_3D_NOTIFY					0x00000104
#define NV20_TCL_PRIMITIVE_3D_WAIT_MAKESPACE				0x00000110
#define NV20_TCL_PRIMITIVE_3D_MAIN_TILES_INDICES			0x00000120
#define NV20_TCL_PRIMITIVE_3D_ASK_FOR_IDLE				0x0000012C
#define NV20_TCL_PRIMITIVE_3D_STALL_PIPELINE				0x00000130
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT0				0x00000180
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT1				0x00000184
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT2				0x00000188
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT2A				0x00000190
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT3				0x00000194
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT4				0x00000198
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT5				0x0000019c
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT6				0x000001a0
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT7				0x000001a4
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT8				0x000001a8
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT9				0x000001ac
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT10				0x000001b0
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_HORIZ				0x00000200
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_VERT				0x00000204
#define NV20_TCL_PRIMITIVE_3D_BUFFER_FORMAT				0x00000208
#define NV20_TCL_PRIMITIVE_3D_BUFFER_PITCH				0x0000020c
#define NV20_TCL_PRIMITIVE_3D_COLOR_OFFSET				0x00000210
#define NV20_TCL_PRIMITIVE_3D_DEPTH_OFFSET				0x00000214
#define NV20_TCL_PRIMITIVE_3D_LMA_DEPTH_BUFFER_PITCH			0x0000022c
#define NV20_TCL_PRIMITIVE_3D_LMA_DEPTH_BUFFER_OFFSET			0x00000230
#define NV20_TCL_PRIMITIVE_3D_W_YUV_FPZ_FLAGS				0x00000290
#define NV20_TCL_PRIMITIVE_3D_LIGHT_CONTROL				0x00000294
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_CONTROL			0x00000298
#define NV20_TCL_PRIMITIVE_3D_FOG_MODE					0x0000029c
#define NV20_TCL_PRIMITIVE_3D_FOG_COORD_DIST				0x000002a0
#define NV20_TCL_PRIMITIVE_3D_FOG_ENABLE				0x000002a4
#define NV20_TCL_PRIMITIVE_3D_FOG_COLOR					0x000002a8
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_CLIP_MODE			0x000002b4	//0/1=accept/reject pixels inside scissors union
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_CLIP_HORIZ(n)			(0x000002c0+(n<<2))
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_CLIP_VERT(n)			(0x000002e0+(n<<2))
#define NV20_TCL_PRIMITIVE_3D_SET_OBJECT_UNKNOWN			0x000002fc
#define NV20_TCL_PRIMITIVE_3D_ALPHA_FUNC_ENABLE				0x00000300
#define NV20_TCL_PRIMITIVE_3D_BLEND_FUNC_ENABLE				0x00000304
#define NV20_TCL_PRIMITIVE_3D_CULL_FACE_ENABLE				0x00000308
#define NV20_TCL_PRIMITIVE_3D_DEPTH_TEST_ENABLE				0x0000030c
#define NV20_TCL_PRIMITIVE_3D_DITHER_ENABLE				0x00000310
#define NV20_TCL_PRIMITIVE_3D_LIGHTING_ENABLE				0x00000314
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETERS_ENABLE			0x00000318
#define NV20_TCL_PRIMITIVE_3D_POINT_SMOOTH_ENABLE			0x0000031c
#define NV20_TCL_PRIMITIVE_3D_LINE_SMOOTH_ENABLE			0x00000320
#define NV20_TCL_PRIMITIVE_3D_POLYGON_SMOOTH_ENABLE			0x00000324
#define NV20_TCL_PRIMITIVE_3D_VERTEX_BLEND_ENABLE			0x00000328
#define NV20_TCL_PRIMITIVE_3D_STENCIL_ENABLE				0x0000032c
#define NV20_TCL_PRIMITIVE_3D_POLYGON_OFFSET_POINT_ENABLE		0x00000330
#define NV20_TCL_PRIMITIVE_3D_POLYGON_OFFSET_LINE_ENABLE		0x00000334
#define NV20_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FILL_ENABLE		0x00000338
#define NV20_TCL_PRIMITIVE_3D_ALPHA_FUNC_FUNC				0x0000033c
#define NV20_TCL_PRIMITIVE_3D_ALPHA_FUNC_REF				0x00000340
#define NV20_TCL_PRIMITIVE_3D_BLEND_FUNC_SRC				0x00000344
#define NV20_TCL_PRIMITIVE_3D_BLEND_FUNC_DST				0x00000348
#define NV20_TCL_PRIMITIVE_3D_BLEND_COLOR				0x0000034c
#define NV20_TCL_PRIMITIVE_3D_BLEND_EQUATION				0x00000350
#define NV20_TCL_PRIMITIVE_3D_DEPTH_FUNC				0x00000354
#define NV20_TCL_PRIMITIVE_3D_COLOR_MASK				0x00000358
#define NV20_TCL_PRIMITIVE_3D_DEPTH_WRITE_ENABLE			0x0000035c
#define NV20_TCL_PRIMITIVE_3D_STENCIL_MASK				0x00000360
#define NV20_TCL_PRIMITIVE_3D_STENCIL_FUNC_FUNC				0x00000364
#define NV20_TCL_PRIMITIVE_3D_STENCIL_FUNC_REF				0x00000368
#define NV20_TCL_PRIMITIVE_3D_STENCIL_FUNC_MASK				0x0000036c
#define NV20_TCL_PRIMITIVE_3D_STENCIL_OP_FAIL				0x00000370
#define NV20_TCL_PRIMITIVE_3D_STENCIL_OP_ZFAIL				0x00000374
#define NV20_TCL_PRIMITIVE_3D_STENCIL_OP_ZPASS				0x00000378
#define NV20_TCL_PRIMITIVE_3D_SHADE_MODEL				0x0000037c
#define NV20_TCL_PRIMITIVE_3D_LINE_WIDTH				0x00000380
#define NV20_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FACTOR			0x00000384
#define NV20_TCL_PRIMITIVE_3D_POLYGON_OFFSET_UNITS			0x00000388
#define NV20_TCL_PRIMITIVE_3D_POLYGON_MODE_FRONT			0x0000038c
#define NV20_TCL_PRIMITIVE_3D_POLYGON_MODE_BACK				0x00000390
#define NV20_TCL_PRIMITIVE_3D_DEPTH_RANGE_NEAR				0x00000394
#define NV20_TCL_PRIMITIVE_3D_DEPTH_RANGE_FAR				0x00000398
#define NV20_TCL_PRIMITIVE_3D_CULL_FACE					0x0000039c
#define NV20_TCL_PRIMITIVE_3D_FRONT_FACE				0x000003a0
#define NV20_TCL_PRIMITIVE_3D_NORMALIZE_ENABLE				0x000003a4
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_R			0x000003a8
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_G			0x000003ac
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_B			0x000003b0
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_A			0x000003b4
#define NV20_TCL_PRIMITIVE_3D_SEPARATE_SPECULAR_ENABLE			0x000003b8
#define NV20_TCL_PRIMITIVE_3D_ENABLED_LIGHTS				0x000003bc
#define NV20_TCL_PRIMITIVE_3D_CLIP_PLANE_ENABLE(n)			(0x000003c0+(n<<2))
#define NV20_TCL_PRIMITIVE_3D_TX_MATRIX_ENABLE(n)			(0x00000420+(n<<2))
#define NV20_TCL_PRIMITIVE_3D_POINT_SIZE				0x0000043c
#define NV20_TCL_PRIMITIVE_3D_MODELVIEW_MATRIX				0x00000480
#define NV20_TCL_PRIMITIVE_3D_INVERSE_MODELVIEW_MATRIX			0x00000580
#define NV20_TCL_PRIMITIVE_3D_PROJECTION_MATRIX				0x00000680
#define NV20_TCL_PRIMITIVE_3D_TX_MATRIX(n)				(0x000006c0+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_CLIP_PLANE_A(n)				(0x00000840+(n<<4))
#define NV20_TCL_PRIMITIVE_3D_CLIP_PLANE_B(n)				(0x00000844+(n<<4))
#define NV20_TCL_PRIMITIVE_3D_CLIP_PLANE_C(n)				(0x00000848+(n<<4))
#define NV20_TCL_PRIMITIVE_3D_CLIP_PLANE_D(n)				(0x0000084c+(n<<4))
#define NV20_TCL_PRIMITIVE_3D_FOG_EQUATION_CONSTANT			0x000009c0
#define NV20_TCL_PRIMITIVE_3D_FOG_EQUATION_LINEAR			0x000009c4
#define NV20_TCL_PRIMITIVE_3D_FOG_EQUATION_QUADRATIC			0x000009c8
#define NV20_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_A		0x000009e0
#define NV20_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_B		0x000009e4
#define NV20_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_C		0x000009e8
#define NV20_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_D		0x000009ec
#define NV20_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_E		0x000009f0
#define NV20_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_F		0x000009f4
#define NV20_TCL_PRIMITIVE_3D_SWATHWIDTH				0x000009f8

#define NV20_TCL_PRIMITIVE_3D_POINT_SPRITE				0x00000a1c

#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_OX				0x00000a20 /* x offset */
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_OY				0x00000a24 /* y offset */
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_DEPTH_AVG_S			0x00000a28 /* (depth range near + far)/2 * 16777214 */
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_UNKNOWN_A			0x00000a2c /* 0.0 if DEPTH_AVG_S == 0.0, otherwise 16777215.0 */
/* see tests draw_pixels, line_stipple and logic_op for where DEPTH_AVG_S=0.0 */

#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_A				0x00000a30
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_B				0x00000a34
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_C				0x00000a38
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_D				0x00000a3c
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_E				0x00000a40
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_F				0x00000a44
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_G				0x00000a48
#define NV20_TCL_PRIMITIVE_3D_POINT_PARAMETER_H				0x00000a4c

#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_PX_DIV2				0x00000af0 /* width/2 */
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_PY_DIV2				0x00000af4 /* -height/2 */
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_DEPTH_HALF_S			0x00000af8 /* (depth range far - near)/2 * 16777214 */
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_UNKNOWN_B			0x00000afc /* always 65535.0 */

#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_INST0				0x00000b00
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_INST1				0x00000b04
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_INST2				0x00000b08
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_INST3				0x00000b0c
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_X				0x00000b80
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_Y				0x00000b84
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_Z				0x00000b88
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_W				0x00000b8c

#define NV20_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_R	0x00000a10
#define NV20_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_G	0x00000a14
#define NV20_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_B	0x00000a18

#define NV20_TCL_PRIMITIVE_3D_TX_OFFSET(n)				(0x00001b00+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_TX_FORMAT(n)				(0x00001b04+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_TX_WRAP(n)				(0x00001b08+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_TX_ENABLE(n)				(0x00001b0c+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_TX_NPOT_PITCH(n)				(0x00001b10+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_TX_FILTER(n)				(0x00001b14+(n<<6))
/*#define NV20_TCL_PRIMITIVE_3D_TX_UNK_B(n)				(0x00001b18+(n<<6))*/
#define NV20_TCL_PRIMITIVE_3D_TX_NPOT_SIZE(n)				(0x00001b1c+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_TX_PALETTE_OFFSET(n)			(0x00001b20+(n<<6))

//									0x00001d78
//									0x00001d7c
//									0x00001d84
#define NV20_TCL_PRIMITIVE_3D_RC_ENABLE					0x00001e60

#define NV20_TCL_PRIMITIVE_3D_TX_SHADER_OP				0x000001e70
#define NV20_TCL_PRIMITIVE_3D_TX_SHADER_CULL_MODE			0x0000017f8
#define NV20_TCL_PRIMITIVE_3D_TX_SHADER_PREVIOUS			0x000001e78

#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_ID			0x00001ea4

#define NV20_TCL_PRIMITIVE_3D_RC_IN_ALPHA(n)				(0x00000260+(n<<2))	/* input combiners, portion alpha */
#define NV20_TCL_PRIMITIVE_3D_RC_IN_RGB(n)				(0x00000ac0+(n<<2))	/* input combiners, portion rgb */
#define NV20_TCL_PRIMITIVE_3D_RC_CONSTANT_COLOR0(n)			(0x00000a60+(n<<2))	/* constant color 0 */
#define NV20_TCL_PRIMITIVE_3D_RC_CONSTANT_COLOR1(n)			(0x00000a80+(n<<2))	/* constant color 1 */
#define NV20_TCL_PRIMITIVE_3D_RC_OUT_ALPHA(n)				(0x00000aa0+(n<<2))	/* output combiners, portion alpha */
#define NV20_TCL_PRIMITIVE_3D_RC_OUT_RGB(n)				(0x00001e40+(n<<2))	/* output combiners, portion rgb */
#define NV20_TCL_PRIMITIVE_3D_RC_COLOR0					0x00001e20	/* combiners, constant colors */
#define NV20_TCL_PRIMITIVE_3D_RC_COLOR1					0x00001e24
#define NV20_TCL_PRIMITIVE_3D_RC_FINAL0					0x00000288	/* final combiner, variables A-D */
#define NV20_TCL_PRIMITIVE_3D_RC_FINAL1					0x0000028c	/* final combiner, variables E-G */

#define NV20_TCL_PRIMITIVE_3D_LIGHT_POSITION_X(n)			(0x0000105c+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_POSITION_Y(n)			(0x00001060+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_POSITION_Z(n)			(0x00001064+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_X(n)			(0x00001028+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_Y(n)			(0x0000102c+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_Z(n)			(0x00001030+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_X(n)			(0x00001034+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_Y(n)			(0x00001038+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_Z(n)			(0x0000103c+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_R(n)	(0x00001000+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_G(n)	(0x00001004+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_B(n)	(0x00001008+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_R(n)	(0x0000100c+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_G(n)	(0x00001010+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_B(n)	(0x00001014+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_R(n)	(0x00001018+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_G(n)	(0x0000101c+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_B(n)	(0x00001020+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_BACK_SIDE_PRODUCT_AMBIENT(n)	(0x00000c00+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_BACK_SIDE_PRODUCT_DIFFUSE(n)	(0x00000c0c+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_BACK_SIDE_PRODUCT_SPECULAR(n)	(0x00000c18+(n<<6))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_CONSTANT_ATTENUATION(n)		(0x00001068+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_LINEAR_ATTENUATION(n)		(0x0000106c+(n<<7))
#define NV20_TCL_PRIMITIVE_3D_LIGHT_QUADRATIC_ATTENUATION(n)		(0x00001070+(n<<7))

/* These commands seem right on NV28, calculations by pq. Note: d = sqrt(dirX^2 + dirY^2 + dirZ^2) */
#define NV20_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_A(n)			(0x00001040+(n<<7)) /* unknown */
#define NV20_TCL_PRIMITIVE_3D_LIGHT_SPOT_EXPONENT(n)			(0x00001044+(n<<7)) /* unknown */
#define NV20_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_B(n)			(0x00001048+(n<<7)) /* unknown */
#define NV20_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_X(n)			(0x0000104c+(n<<7)) /* 1/( cos(cutoff)-1 ) * dirX/d */
#define NV20_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_Y(n)			(0x00001050+(n<<7)) /* 1/( cos(cutoff)-1 ) * dirY/d */
#define NV20_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_Z(n)			(0x00001054+(n<<7)) /* 1/( cos(cutoff)-1 ) * dirZ/d */
#define NV20_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_C(n)			(0x00001058+(n<<7)) /* 1 + 1/( cos(cutoff)-1 ) */

#define NV20_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_A			0x00001e28
#define NV20_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_B			0x00001e2c
#define NV20_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_C			0x00001e30
#define NV20_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_D			0x00001e34
#define NV20_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_E			0x00001e38
#define NV20_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_F			0x00001e3c

#define NV20_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_ENABLE			0x0000147c
#define NV20_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_PATTERN(n)		(0x00001480+(n<<2))
#define NV20_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_PATTERN__SIZE		32

#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_3F_X				0x00001500
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_3F_Y				0x00001504
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_3F_Z				0x00001508
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_4F_X				0x00001518
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_4F_Y				0x0000151c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_4F_Z				0x00001520
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_4F_W				0x00001524
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_4I_XY				0x00001528
#define NV20_TCL_PRIMITIVE_3D_VERTEX_POS_4I_ZW				0x0000152c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_X				0x00001530
#define NV20_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_Y				0x00001534
#define NV20_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_Z				0x00001538
#define NV20_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_XY				0x00001540
#define NV20_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_Z				0x00001544
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_4F_R				0x00001550
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_4F_G				0x00001554
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_4F_B				0x00001558
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_4F_A				0x0000155c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_3F_R				0x00001560
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_3F_G				0x00001564
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_3F_B				0x00001568
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL_4I				0x0000156c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_R				0x00001580
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_G				0x00001584
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_B				0x00001588
#define NV20_TCL_PRIMITIVE_3D_VERTEX_COL2_3I				0x0000158c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_S				0x00001590
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_T				0x00001594
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_2I				0x00001598
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_S				0x000015a0
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_T				0x000015a4
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_R				0x000015a8
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_Q				0x000015ac
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_ST				0x000015b0
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_RQ				0x000015b4
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_S				0x000015b8
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_T				0x000015bc
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_2I				0x000015c0
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_S				0x000015c8
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_T				0x000015cc
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_R				0x000015d0
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_Q				0x000015d4
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_ST				0x000015d8
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_RQ				0x000015dc
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_2F_S				0x000015e0
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_2F_T				0x000015e4
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_2I				0x000015e8
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_S				0x000015f0
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_T				0x000015f4
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_R				0x000015f8
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_Q				0x000015fc
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_4I_ST				0x00001600
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX2_4I_RQ				0x00001604
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_2F_S				0x00001608
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_2F_T				0x0000160c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_2I				0x00001610
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_S				0x00001620
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_T				0x00001624
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_R				0x00001628
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_Q				0x0000162c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_4I_ST				0x00001630
#define NV20_TCL_PRIMITIVE_3D_VERTEX_TX3_4I_RQ				0x00001634
#define NV20_TCL_PRIMITIVE_3D_VERTEX_FOG_1F				0x00001698
#define NV20_TCL_PRIMITIVE_3D_EDGE_FLAG					0x000016bc

#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR0_POS			0x00001720
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR1_WGH			0x00001724
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR2_NOR			0x00001728
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR3_COL			0x0000172c
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR4_COL2			0x00001730
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR5_FOG			0x00001734
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR6				0x00001738
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR7				0x0000173c
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR8_TX0			0x00001740
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR9_TX1			0x00001744
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR10_TX2			0x00001748
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR11_TX3			0x0000174c
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR12_TX4			0x00001750
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR13_TX5			0x00001754
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR14_TX6			0x00001758
#define NV20_TCL_PRIMITIVE_3D_VB_POINTER_ATTR15_TX7			0x0000175c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR(i)				(0x00001760 + (i * 0x04))
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR__SIZE				16
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR0_POS				0x00001760
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR1_WGH				0x00001764
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR2_NOR				0x00001768
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR3_COL				0x0000176c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR4_COL2				0x00001770
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR5_FOG				0x00001774
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR6				0x00001778
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR7				0x0000177c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR8_TX0				0x00001780
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR9_TX1				0x00001784
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR10_TX2				0x00001788
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR11_TX3				0x0000178c
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR12_TX4				0x00001790
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR13_TX5				0x00001794
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR14_TX6				0x00001798
#define NV20_TCL_PRIMITIVE_3D_VERTEX_ATTR15_TX7				0x0000179c

#define NV20_TCL_PRIMITIVE_3D_LIGHT_MODEL_BACK_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_R	0x000017a0
#define NV20_TCL_PRIMITIVE_3D_LIGHT_MODEL_BACK_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_G	0x000017a4
#define NV20_TCL_PRIMITIVE_3D_LIGHT_MODEL_BACK_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_B	0x000017a8
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_A			0x000017ac
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_R			0x000017b0
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_G			0x000017b4
#define NV20_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_B			0x000017b8
#define NV20_TCL_PRIMITIVE_3D_COLOR_LOGIC_OP_ENABLE			0x000017bc
#define NV20_TCL_PRIMITIVE_3D_COLOR_LOGIC_OP_OP				0x000017c0
#define NV20_TCL_PRIMITIVE_3D_LIGHT_MODEL_TWO_SIDE_ENABLE		0x000017c4
//									0x000017cc
#define NV20_TCL_PRIMITIVE_3D_BEGIN_END					0x000017fc

#define NV20_TCL_PRIMITIVE_3D_TX_DEPTH_UNIT(n)				(0x00001840 + (n*4))
#define NV20_TCL_PRIMITIVE_3D_TX_ADDRESS_UNIT(n)			(0x00001A00 + (n * 32))
#define NV20_TCL_PRIMITIVE_3D_TX_FORMAT_UNIT(n)				(0x00001A04 + (n * 32))
#define NV20_TCL_PRIMITIVE_3D_TX_FORMAT_MIPMAP_COUNT			23:20
#define NV20_TCL_PRIMITIVE_3D_TX_FORMAT_TYPE				14:13
#define NV20_TCL_PRIMITIVE_3D_TX_FORMAT_FORMAT				12:8
#define NV20_TCL_PRIMITIVE_3D_TX_FORMAT_NCOMP				7:4 /* 2=2D, 3=3D, high bit may be wrong */
#define NV20_TCL_PRIMITIVE_3D_TX_FORMAT_CUBIC				2:2
#define NV20_TCL_PRIMITIVE_3D_TX_WRAP_UNIT(n)				(0x00001A08 + (n * 32))
#define NV20_TCL_PRIMITIVE_3D_TX_WRAP_S					7:0
#define NV20_TCL_PRIMITIVE_3D_TX_WRAP_T					15:8
#define NV20_TCL_PRIMITIVE_3D_TX_WRAP_R					23:16
#define NV20_TCL_PRIMITIVE_3D_TX_UNK03_UNIT(n)				(0x00001A0C + (n * 32))
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_UNIT(n)			(0x00001A10 + (n * 32))
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_S0_ZERO			0
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_S0_ONE				1
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_S0_S1				2
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_X				3
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_Y				2
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_Z				1
#define NV20_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_W				0
#define NV20_TCL_PRIMITIVE_3D_TX_FILTER_UNIT(n)				(0x00001A14 + (n * 32))
#define NV20_TCL_PRIMITIVE_3D_TX_FILTER_MIN				19:16
#define NV20_TCL_PRIMITIVE_3D_TX_FILTER_MAG				27:24
#define NV20_TCL_PRIMITIVE_3D_TX_XY_DIM_UNIT(n)				(0x00001A18 + (n * 32))
#define NV20_TCL_PRIMITIVE_3D_TX_UNK07_UNIT(n)				(0x00001A1C + (n * 32))

#define NV20_TCL_PRIMITIVE_3D_INDEX_DATA				0x00001800
#define NV20_TCL_PRIMITIVE_3D_VB_VERTEX_BATCH				0x00001810
#define NV20_TCL_PRIMITIVE_3D_VERTEX_DATA				0x00001818
//									0x00001c18
#define NV20_TCL_PRIMITIVE_3D_SCISSOR_X2_X1				0x00001c30
#define NV20_TCL_PRIMITIVE_3D_SCISSOR_Y2_Y1				0x00001c50
#define NV20_TCL_PRIMITIVE_3D_ACTIVATE_COLORS				0x00001d6c
#define NV20_TCL_PRIMITIVE_3D_MULTISAMPLE				0x00001d7c	//bit0:MultiSampleAntiAliasing bits31-16:MultiSampleMask
#define NV20_TCL_PRIMITIVE_3D_CULL_ENABLE				0x00001d84	//bit0:OcclusionCullEnable bit1:StencilCullEnable
#define NV20_TCL_PRIMITIVE_3D_PARAMETER_A				0x00001d8c	//connects with MMIO 0x00401A88 (useful to pass parameters to interrupt routines)
#define NV20_TCL_PRIMITIVE_3D_PARAMETER_B				0x00001d90	//connects with MMIO 0x0040186C (useful to pass parameters to interrupt routines)
#define NV20_TCL_PRIMITIVE_3D_CLEAR_VALUE_DEPTH				0x00001d8c
#define NV20_TCL_PRIMITIVE_3D_CLEAR_VALUE_ARGB				0x00001d90
#define NV20_TCL_PRIMITIVE_3D_CLEAR_WHICH_BUFFERS			0x00001d94	//used to trigger clear operation (Parameters A & B are then considered depth & color values)
#define NV20_TCL_PRIMITIVE_3D_CLEAR_VALUE_HORIZ				0x00001d98
#define NV20_TCL_PRIMITIVE_3D_CLEAR_VALUE_VERT				0x00001d9c
#define NV20_TCL_PRIMITIVE_3D_SHADOW_FUNC_FUNC				0x00001e6c
#define NV20_TCL_PRIMITIVE_3D_TX_SHADER_DOTMAPPING			0x00001e74 	//(0 means [0,255]argb from texture=>[0.0,1.0](r,g,b))
#define NV20_TCL_PRIMITIVE_3D_SHADER_TYPE				0x00001e94
#define 	SHADER_TYPE_INTERNAL	4
#define 	SHADER_TYPE_EXTERNAL	6
#define NV20_TCL_PRIMITIVE_3D_SHADER_SUBTYPE				0x00001e98
#define		SHADER_SUBTYPE_REGULAR	0 						//not allowed to write into constants: faster
#define NV20_TCL_PRIMITIVE_3D_VP_UPLOAD_FROM_ID				0x00001e9C
#define NV20_TCL_PRIMITIVE_3D_VP_PROGRAM_START_ID			0x00001ea0
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_X				0x00001f00
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_Y				0x00001f04
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_Z				0x00001f08
#define NV20_TCL_PRIMITIVE_3D_VIEWPORT_ORIGIN_W				0x00001f0c


#define NV30_TCL_PRIMITIVE_3D				0x00000097

#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT0		0x00000180
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT1		0x00000184
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT2		0x00000188
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT3		0x0000018C
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT4		0x00000194
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT5		0x00000198
#define NV30_TCL_PRIMITIVE_3D_SET_VB_SRC0_OBJECT	0x0000019C
#define NV30_TCL_PRIMITIVE_3D_SET_VB_SRC1_OBJECT	0x000001A0
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT6		0x000001A4 /* see NV30_TCL_PRIMITIVE_3D_UNK1D6C/1D70 */
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT7		0x000001A8
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT8		0x000001AC
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT8B		0x000001B0
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT9		0x000001B4
#define NV30_TCL_PRIMITIVE_3D_SET_OBJECT10		0x000001B8
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_COLOR_BUFFER_DIM0	0x00000200 ///< X dims and offset. Please see doc/nv40_color_buff.txt
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_COLOR_BUFFER_DIM1	0x00000204 ///< Y dims and offset
#define NV30_TCL_PRIMITIVE_3D_BUFFER_FORMAT		0x00000208
#define NV30_TCL_PRIMITIVE_3D_BUFFER0_PITCH		0x0000020c
#define NV30_TCL_PRIMITIVE_3D_COLOR0_OFFSET		0x00000210
#define NV30_TCL_PRIMITIVE_3D_DEPTH_OFFSET		0x00000214
#define NV30_TCL_PRIMITIVE_3D_COLOR1_OFFSET		0x00000218
#define NV30_TCL_PRIMITIVE_3D_BUFFER1_PITCH		0x0000021c
#define NV30_TCL_PRIMITIVE_3D_ENABLED_BUFFERS		0x00000220
#define NV30_TCL_PRIMITIVE_3D_LMA_DEPTH_BUFFER_PITCH	0x0000022c
#define NV30_TCL_PRIMITIVE_3D_LMA_DEPTH_BUFFER_OFFSET	0x00000230
#define NV30_TCL_PRIMITIVE_3D_TX_MATRIX_ENABLE(n)	(0x0000240+(n<<2))
#define NV30_TCL_PRIMITIVE_3D_BUFFER2_PITCH		0x00000280
#define NV30_TCL_PRIMITIVE_3D_BUFFER3_PITCH		0x00000284
#define NV30_TCL_PRIMITIVE_3D_BUFFER2_OFFSET		0x00000288
#define NV30_TCL_PRIMITIVE_3D_BUFFER3_OFFSET		0x0000028c
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_COLOR_BUFFER_OFS0	0x000002c0 ///< Offset and modulo for width
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_COLOR_BUFFER_OFS1	0x000002c4 ///< Offset and modulo for height
#define NV30_TCL_PRIMITIVE_3D_DITHER_ENABLE		0x00000300
#define NV30_TCL_PRIMITIVE_3D_ALPHA_FUNC_ENABLE		0x00000304
#define NV30_TCL_PRIMITIVE_3D_ALPHA_FUNC_FUNC  		0x00000308
#define NV30_TCL_PRIMITIVE_3D_ALPHA_FUNC_REF		0x0000030c
#define NV30_TCL_PRIMITIVE_3D_BLEND_FUNC_ENABLE		0x00000310
#define NV30_TCL_PRIMITIVE_3D_BLEND_FUNC_SRC		0x00000314
#define NV30_TCL_PRIMITIVE_3D_BLEND_FUNC_DST		0x00000318
#define NV30_TCL_PRIMITIVE_3D_BLEND_COLOR		0x0000031c
#define NV30_TCL_PRIMITIVE_3D_BLEND_EQUATION		0x00000320
#define NV30_TCL_PRIMITIVE_3D_COLOR_MASK		0x00000324
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_ENABLE	0x00000328
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_MASK		0x0000032c
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_FUNC_FUNC	0x00000330
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_FUNC_REF	0x00000334
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_FUNC_MASK	0x00000338
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_OP_FAIL	0x0000033c
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_OP_ZFAIL	0x00000340
#define NV30_TCL_PRIMITIVE_3D_STENCIL_BACK_OP_ZPASS	0x00000344
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_ENABLE	0x00000348
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_MASK	0x0000034c
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_FUNC_FUNC	0x00000350
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_FUNC_REF	0x00000354
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_FUNC_MASK	0x00000358
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_OP_FAIL	0x0000035c
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_OP_ZFAIL	0x00000360
#define NV30_TCL_PRIMITIVE_3D_STENCIL_FRONT_OP_ZPASS	0x00000364
#define NV30_TCL_PRIMITIVE_3D_SHADE_MODEL		0x00000368
#define NV30_TCL_PRIMITIVE_3D_FOG_ENABLE		0x0000036c
#define NV30_TCL_PRIMITIVE_3D_FOG_COLOR                 0x00000370
#define NV30_TCL_PRIMITIVE_3D_COLOR_LOGIC_OP_ENABLE	0x00000374
#define NV30_TCL_PRIMITIVE_3D_COLOR_LOGIC_OP_OP		0x00000378
#define NV30_TCL_PRIMITIVE_3D_NORMALIZE_ENABLE		0x0000037c
#define NV30_TCL_PRIMITIVE_3D_DEPTH_RANGE_NEAR		0x00000394
#define NV30_TCL_PRIMITIVE_3D_DEPTH_RANGE_FAR		0x00000398
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_R	0x000003a0
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_G	0x000003a4
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_B	0x000003a8
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_FRONT_A	0x000003b4
#define NV30_TCL_PRIMITIVE_3D_LINE_WIDTH_SMOOTH		0x000003b8
#define NV30_TCL_PRIMITIVE_3D_LINE_SMOOTH_ENABLE	0x000003bc
#define NV30_TCL_PRIMITIVE_3D_CLIP_PLANE_ENABLE(n)	(0x00000400+(n<<2))
#define NV30_TCL_PRIMITIVE_3D_MODELVIEW_MATRIX		0x00000480
#define NV30_TCL_PRIMITIVE_3D_INVERSE_MODELVIEW_MATRIX	0x00000580
#define NV30_TCL_PRIMITIVE_3D_PROJECTION_MATRIX		0x00000680
#define NV30_TCL_PRIMITIVE_3D_TX_MATRIX(n)		(0x000006c0+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_SCISSOR_WIDTH_XPOS        0x000008c0      ///< Set the width and xpos of glScissor()
#define NV30_TCL_PRIMITIVE_3D_SCISSOR_HEIGHT_YPOS	0x000008c4	///< Set the height and ypos of glScissor()
#define NV30_TCL_PRIMITIVE_3D_FP_ACTIVE_PROGRAM		0x000008e4
#define NV30_TCL_PRIMITIVE_3D_FOG_COORD_DIST		0x000008c8
#define NV30_TCL_PRIMITIVE_3D_FOG_MODE			0x000008cc
#define NV30_TCL_PRIMITIVE_3D_FOG_EQUATION_CONSTANT	0x000008d0
#define NV30_TCL_PRIMITIVE_3D_FOG_EQUATION_LINEAR	0x000008d4
#define NV30_TCL_PRIMITIVE_3D_FOG_EQUATION_QUADRATIC	0x000008d8
#define NV30_TCL_PRIMITIVE_3D_RC_COLOR0			0x000008ec
#define NV30_TCL_PRIMITIVE_3D_RC_COLOR1			0x000008f0
#define NV30_TCL_PRIMITIVE_3D_RC_FINAL0			0x000008f4
#define NV30_TCL_PRIMITIVE_3D_RC_FINAL1			0x000008f8
#define NV30_TCL_PRIMITIVE_3D_RC_ENABLE			0x000008fc
#define NV30_TCL_PRIMITIVE_3D_RC_IN_ALPHA(n)		(0x00000900+(n<<5))
#define NV30_TCL_PRIMITIVE_3D_RC_IN_RGB(n)		(0x00000904+(n<<5))
#define NV30_TCL_PRIMITIVE_3D_RC_CONSTANT_COLOR0(n)	(0x00000908+(n<<5))
#define NV30_TCL_PRIMITIVE_3D_RC_CONSTANT_COLOR1(n)	(0x0000090c+(n<<5))
#define NV30_TCL_PRIMITIVE_3D_RC_OUT_ALPHA(n)		(0x00000910+(n<<5))
#define NV30_TCL_PRIMITIVE_3D_RC_OUT_RGB(n)		(0x00000914+(n<<5))
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_0		0x00000a00
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_0_WIDTH	31:16
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_0_XOFFS	15:0
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_1		0x00000a04
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_0_HEIGHT	31:16
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_0_YOFFS	15:0
#define NV30_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_R	0x00000a10
#define NV30_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_G	0x00000a14
#define NV30_TCL_PRIMITIVE_3D_LIGHT_MODEL_FRONT_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_B	0x00000a18
/* VIEWPORT_XFRM_* are FP32 values */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_OX		0x00000a20	/* center X? */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_OY		0x00000a24	/* center Y? */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_NPF_DIV2	0x00000a28	/* (near+far)/2 */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_UNK0_0x0	0x00000a2c	/* always 0? */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_PX_DIV2	0x00000a30	/* width/2 */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_PY_DIV2	0x00000a34	/* -(height/2) */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_FMN_DIV2	0x00000a38	/* (far-near)/2 */
#define NV30_TCL_PRIMITIVE_3D_VIEWPORT_XFRM_UNK1_0x0	0x00000a3c	/* always 0? */
#define NV30_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FILL_ENABLE	0x00000a60
#define NV30_TCL_PRIMITIVE_3D_POLYGON_OFFSET_LINE_ENABLE	0x00000a64
#define NV30_TCL_PRIMITIVE_3D_POLYGON_OFFSET_POINT_ENABLE	0x00000a68
#define NV30_TCL_PRIMITIVE_3D_DEPTH_FUNC		0x00000a6c
#define NV30_TCL_PRIMITIVE_3D_DEPTH_WRITE_ENABLE	0x00000a70
#define NV30_TCL_PRIMITIVE_3D_DEPTH_TEST_ENABLE		0x00000a74
#define NV30_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FACTOR	0x00000a78
#define NV30_TCL_PRIMITIVE_3D_POLYGON_OFFSET_UNITS 	0x00000a7c /* units*2  ?? */
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_INST0		0x00000b80
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_INST1		0x00000b84
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_INST2		0x00000b88
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_INST3		0x00000b8c
#define NV30_TCL_PRIMITIVE_3D_CLIP_PLANE_A(n)		(0x00000e00+(n<<4))
#define NV30_TCL_PRIMITIVE_3D_CLIP_PLANE_B(n)		(0x00000e04+(n<<4))
#define NV30_TCL_PRIMITIVE_3D_CLIP_PLANE_C(n)		(0x00000e08+(n<<4))
#define NV30_TCL_PRIMITIVE_3D_CLIP_PLANE_D(n)		(0x00000e0c+(n<<4))

#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_R(n)	(0x00001000+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_G(n)	(0x00001004+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_AMBIENT_B(n)	(0x00001008+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_R(n)	(0x0000100c+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_G(n)	(0x00001010+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_DIFFUSE_B(n)	(0x00001014+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_R(n)	(0x00001018+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_G(n)	(0x0000101c+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_FRONT_SIDE_PRODUCT_SPECULAR_B(n)	(0x00001020+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_X(n)			(0x00001028+(n<<7))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_Y(n)			(0x0000102c+(n<<7))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_HALF_VECTOR_Z(n)			(0x00001030+(n<<7))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_X(n)			(0x00001034+(n<<7))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_Y(n)			(0x00001038+(n<<7))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_DIRECTION_Z(n)			(0x0000103c+(n<<7))

#define NV30_TCL_PRIMITIVE_3D_LIGHT_CONSTANT_ATTENUATION(n)		(0x00001228+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_LINEAR_ATTENUATION(n)		(0x0000122c+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_QUADRATIC_ATTENUATION(n)		(0x00001230+(n<<6))

/* These commands seem right on NV34, but I do not know how the parameters are
 * calculated. */
#define NV30_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_A(n)			(0x00001200+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_SPOT_EXPONENT(n)			(0x00001204+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_B(n)			(0x00001208+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_X(n)			(0x0000120c+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_Y(n)			(0x00001210+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_SPOT_DIR_Z(n)			(0x00001214+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_SPOT_CUTOFF_C(n)			(0x00001218+(n<<6))

#define NV30_TCL_PRIMITIVE_3D_LIGHT_POSITION_X(n)			(0x0000121c+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_POSITION_Y(n)			(0x00001220+(n<<6))
#define NV30_TCL_PRIMITIVE_3D_LIGHT_POSITION_Z(n)			(0x00001224+(n<<6))

#define NV30_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_A		0x00001400
#define NV30_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_B		0x00001404
#define NV30_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_C		0x00001408
#define NV30_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_D		0x0000140c
#define NV30_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_E		0x00001410
#define NV30_TCL_PRIMITIVE_3D_FRONT_MATERIAL_SHININESS_F		0x00001414
#define NV30_TCL_PRIMITIVE_3D_ENABLED_LIGHTS				0x00001420

/** 
  Clipping planes enable / Disable  <BR/>                   
  for each clipping plane first the matrix is uploaded followed by
  a 0x1478. The 32 bit parameter is a bitmap, where bit (plane * 2 +1) is 
  set for each active bitmap. Clearing this bit would deactivate the clipping plane
  So for Clipping planes 0, 2 and 3 to be enabled you would see
  0x1478 0x00002202.
  So effectively 16 bit of the 32 bits are used for clipping planes. Currently
  the use of the other 16 bit is unknown.
  
*/


#define NV30_TCL_PRIMITIVE_3D_SET_CLIPPING_PLANES       0x00001478
#define NV30_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_ENABLE	0x0000147C
#define NV30_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_PATTERN(i)	(0x00001480 + (i<<2))
#define NV30_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_PATTERN__SIZE	32


/* These seem to contain default values for each vertex attribute (0-15).
 * Values set outside of glBegin()/glEnd() appear here.
 */
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_3X(a)		(0x00001500 + (a * 0x10))
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_3Y(a)		(0x00001504 + (a * 0x10))
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_3Z(a)		(0x00001508 + (a * 0x10))
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_3W(a)		(0x0000150C + (a * 0x10)) /* This exists, but not used on gl*4f calls.. */
#define NV30_TCL_PRIMITIVE_3D_VB_POINTER_ATTR(a)	(0x00001680 + (a * 0x04))

#define NV30_TCL_PRIMITIVE_3D_VERTEX_UNK_0		0x00001718
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR(i)		(0x00001740 + (i * 0x04))
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR__SIZE		16
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR0_POS		0x00001740
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR1_WGH		0x00001744
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR2_NOR		0x00001748
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR3_COL		0x0000174c
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR4_COL2		0x00001750
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR5_FOG		0x00001754
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR6		0x00001758
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR7		0x0000175c
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR8_TX0		0x00001760
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR9_TX1		0x00001764
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR10_TX2		0x00001768
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR11_TX3		0x0000176c
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR12_TX4		0x00001770
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR13_TX5		0x00001774
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR14_TX6		0x00001778
#define NV30_TCL_PRIMITIVE_3D_VERTEX_ATTR15_TX7		0x0000177c
#define NV30_TCL_PRIMITIVE_3D_LIGHT_MODEL_BACK_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_R	0x000017a0
#define NV30_TCL_PRIMITIVE_3D_LIGHT_MODEL_BACK_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_G	0x000017a4
#define NV30_TCL_PRIMITIVE_3D_LIGHT_MODEL_BACK_SIDE_PRODUCT_AMBIENT_PLUS_EMISSION_B	0x000017a8
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_R	0x000017b0
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_G	0x000017b4
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_B	0x000017b8
#define NV30_TCL_PRIMITIVE_3D_COLOR_MATERIAL_BACK_A	0x000017c0
/**
  \brief   Enable Color buffer or Occlusion query
  This primitive is called on two occasions: 
   <UL>
    <LI>If you clear the color buffer, you will see this command
        with value of 0x00000002
    <LI>If you are enabling an occlusion query, you will see
        this command with a value of 0x00000001
   </UL>
*/
#define NV30_TCL_PRIMITIVE_3D_OCC_QUERY_OR_COLOR_BUFF_ENABLE    0x000017c8
/**
  \brief  store the result of an occlusion query

  This primitive is called on two occasions: 
   <UL>
    <LI>If you clear the color buffer, you will see this command
        with value of 0x00000002 (Red?), 0x00000003 (Green?),
        0x00000004 (Blue?), and 0x00000005 (Alpha?)
    <LI>If you are enabling an occlusion query, you will see
        this command with a value of 0x01vvvvvv
        <code>vvvvvv</code> defines the query number (starting from 0)
        multiplied with 16
   </UL>
*/
#define NV30_TCL_PRIMITIVE_3D_STORE_RESULT              0x00001800
#define NV30_TCL_PRIMITIVE_3D_BEGIN_END			0x00001808
#define NV30_TCL_PRIMITIVE_3D_VB_ELEMENT_U16		0x0000180c
#define NV30_TCL_PRIMITIVE_3D_VB_ELEMENT_U32		0x00001810
#define NV30_TCL_PRIMITIVE_3D_VB_VERTEX_BATCH		0x00001814
#define NV30_TCL_PRIMITIVE_3D_VERTEX_DATA		0x00001818
#define NV30_TCL_PRIMITIVE_3D_SET_DISPLAY_LIST_MEM_OFFSET 	0x0000181c
#define NV30_TCL_PRIMITIVE_3D_EXECUTE_DISPLAY_LIST	0x00001824
#define NV30_TCL_PRIMITIVE_3D_POLYGON_MODE_FRONT	0x00001828
#define NV30_TCL_PRIMITIVE_3D_POLYGON_MODE_BACK		0x0000182c
#define NV30_TCL_PRIMITIVE_3D_CULL_FACE			0x00001830
#define NV30_TCL_PRIMITIVE_3D_FRONT_FACE		0x00001834
#define NV30_TCL_PRIMITIVE_3D_POLYGON_SMOOTH_ENABLE	0x00001838
#define NV30_TCL_PRIMITIVE_3D_CULL_FACE_ENABLE		0x0000183c
#define NV30_TCL_PRIMITIVE_3D_TX_DEPTH_UNIT(n)		(0x00001840 + (n*4))
#define NV30_TCL_PRIMITIVE_3D_TX_DEPTH			31:24
#define NV30_TCL_PRIMITIVE_3D_TX_NPOT_PITCH		23:0
#define NV30_TCL_PRIMITIVE_3D_TX_ADDRESS_UNIT(n)	(0x00001A00 + (n * 32))
#define NV30_TCL_PRIMITIVE_3D_TX_FORMAT_UNIT(n)		(0x00001A04 + (n * 32))
#define NV30_TCL_PRIMITIVE_3D_TX_FORMAT_MIPMAP_COUNT	23:20
#define NV30_TCL_PRIMITIVE_3D_TX_FORMAT_TYPE		14:13
#define NV30_TCL_PRIMITIVE_3D_TX_FORMAT_FORMAT		12:8
#define NV30_TCL_PRIMITIVE_3D_TX_FORMAT_NCOMP		7:4 /* 2=2D, 3=3D, high bit may be wrong */
#define NV30_TCL_PRIMITIVE_3D_TX_FORMAT_CUBIC		2:2
#define NV30_TCL_PRIMITIVE_3D_TX_WRAP_UNIT(n)		(0x00001A08 + (n * 32))
#define NV30_TCL_PRIMITIVE_3D_TX_WRAP_S			7:0
#define NV30_TCL_PRIMITIVE_3D_TX_WRAP_T			15:8
#define NV30_TCL_PRIMITIVE_3D_TX_WRAP_R			23:16
#define NV30_TCL_PRIMITIVE_3D_TX_ENABLE_UNIT(n)		(0x00001A0C + (n * 32))
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_UNIT(n)	(0x00001A10 + (n * 32))
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_S0_ZERO	0
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_S0_ONE		1
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_S0_S1		2
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_X		3
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_Y		2
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_Z		1
#define NV30_TCL_PRIMITIVE_3D_TX_SWIZZLE_S1_W		0
#define NV30_TCL_PRIMITIVE_3D_TX_FILTER_UNIT(n)		(0x00001A14 + (n * 32))
#define NV30_TCL_PRIMITIVE_3D_TX_FILTER_MIN		19:16
#define NV30_TCL_PRIMITIVE_3D_TX_FILTER_MAG		27:24
#define NV30_TCL_PRIMITIVE_3D_TX_XY_DIM_UNIT(n)		(0x00001A18 + (n * 32))
#define NV30_TCL_PRIMITIVE_3D_TX_UNK07_UNIT(n)		(0x00001A1C + (n * 32))
/* These seem to contain default values for each vertex attribute (0-15).
 * Values set outside of glBegin()/glEnd() appear here.
 */
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_4X(a)		(0x00001C00 + (a * 0x10))
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_4Y(a)		(0x00001C04 + (a * 0x10))
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_4Z(a)		(0x00001C08 + (a * 0x10))
#define NV30_TCL_PRIMITIVE_3D_VTX_ATTR_4W(a)		(0x00001C0C + (a * 0x10))

#define NV30_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_XY		0x00000a90
#define NV30_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_Z		0x00000a94
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_S		0x000018c0
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_T		0x000018c4
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_S		0x000018c8
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_T		0x000018cc
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX2_2F_S		0x000018d0
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX2_2F_T		0x000018d4
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX3_2F_S		0x000018d8
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX3_2F_T		0x000018dc
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX0_2I		0x00001920
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX1_2I		0x00001924
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX2_2I		0x00001928
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX3_2I		0x0000192c
#define NV30_TCL_PRIMITIVE_3D_VERTEX_COL_4I		0x0000194c
#define NV30_TCL_PRIMITIVE_3D_VERTEX_COL2_3I		0x00001950
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_ST		0x000019c0
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_RQ		0x000019c4
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_ST		0x000019c8
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_RQ		0x000019cc
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX2_4I_ST		0x000019d0
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX2_4I_RQ		0x000019d4
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX3_4I_ST		0x000019d8
#define NV30_TCL_PRIMITIVE_3D_VERTEX_TX3_4I_RQ		0x000019dc
#define NV30_TCL_PRIMITIVE_3D_FP_CONTROL		0x00001d60
#define NV30_TCL_PRIMITIVE_3D_VERTEX_FOG_1F		0x00001e54
/* Offset into the memory pointed at by dma object specified in SET_OBJECT6 */
#define NV30_TCL_PRIMITIVE_3D_UNK1D6C_OFFSET		0x00001d6c
/* Write VALUE at the offset specified in UNK1D6C_OFFSET */
#define NV30_TCL_PRIMITIVE_3D_UNK1D70_VALUE		0x00001d70
#define NV30_TCL_PRIMITIVE_3D_LINE_STIPPLE_ENABLE	0x00001db4
#define NV30_TCL_PRIMITIVE_3D_LINE_STIPPLE_PATTERN 	0x00001db8
#define NV30_TCL_PRIMITIVE_3D_CLEAR_VALUE_DEPTH		0x00001d8c
#define NV30_TCL_PRIMITIVE_3D_CLEAR_VALUE_ARGB		0x00001d90
/* CLEAR_WHICH_BUFFERS initiates the clear operation */
#define NV30_TCL_PRIMITIVE_3D_CLEAR_WHICH_BUFFERS	0x00001d94
#define NV30_TCL_PRIMITIVE_3D_DO_VERTICES		0x00001dac
#define NV30_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_A	0x00001e20
#define NV30_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_B	0x00001e24
#define NV30_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_C	0x00001e28
#define NV30_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_D	0x00001e2c
#define NV30_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_E	0x00001e30
#define NV30_TCL_PRIMITIVE_3D_BACK_MATERIAL_SHININESS_F	0x00001e34
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_FROM_ID		0x00001e9C
#define NV30_TCL_PRIMITIVE_3D_VP_PROGRAM_START_ID	0x00001ea0
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_A		0x00001ec0
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_B		0x00001ec4
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_C		0x00001ec8
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_D		0x00001ecc
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_E		0x00001ed0
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_F		0x00001ed4
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_G		0x00001ed8
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETER_H		0x00001edc
#define NV30_TCL_PRIMITIVE_3D_POINT_SIZE                0x00001ee0
#define NV30_TCL_PRIMITIVE_3D_POINT_PARAMETERS_ENABLE	0x00001ee4
#define NV30_TCL_PRIMITIVE_3D_POINT_SPRITE		0x00001ee8
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_ID	0x00001efc
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P0_X	0x00001f00
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P0_Y	0x00001f04
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P0_Z	0x00001f08
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P0_W	0x00001f0C
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P1_X	0x00001f10
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P1_Y	0x00001f14
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P1_Z	0x00001f18
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P1_W	0x00001f1C
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P2_X	0x00001f20
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P2_Y	0x00001f24
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P2_Z	0x00001f28
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P2_W	0x00001f2C
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P3_X	0x00001f30
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P3_Y	0x00001f34
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P3_Z	0x00001f38
#define NV30_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_P3_W	0x00001f3C
#define NV30_TCL_PRIMITIVE_3D_VP_IN_REG			0x00001ff0
#define NV30_TCL_PRIMITIVE_3D_VP_OUT_REG		0x00001ff4


#define NV40_TCL_PRIMITIVE_3D				0x00000097
#define NV40_TCL_PRIMITIVE_3D_COLOR_MASK_BUFFER123	0x00000370


#define NV30_CLEAR_BUFFER				0x00000066
#define NV30_CLEAR_BUFFER_SET_DMA_NOTIFY		0x00000180
#define NV30_CLEAR_BUFFER_SET_IMAGE_PATTERN		0x00000188
#define NV30_CLEAR_BUFFER_SET_RASTER_OP			0x0000018c
#define NV30_CLEAR_BUFFER_SET_CONTEXT_SURFACE_2D	0x00000198
#define NV30_CLEAR_BUFFER_UNK002fc			0x000002fc


#define NV50_TCL_PRIMITIVE_3D					0x00000097

#define NV50_TCL_PRIMITIVE_3D_SET_OBJECT_0(n)			(0x00000180 + (n<<2))
#define NV50_TCL_PRIMITIVE_3D_SET_OBJECT_0__SIZE		12
#define NV50_TCL_PRIMITIVE_3D_SET_OBJECT_1(n)			(0x000001c0 + (n<<2))
#define NV50_TCL_PRIMITIVE_3D_SET_OBJECT_1__SIZE		8
#define NV50_TCL_PRIMITIVE_3D_VERTEX_FOG_1F			0x00000314
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_2F_X			0x00000380
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_2F_Y			0x00000384
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_S			0x000003c0
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_2F_T			0x000003c4
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_S			0x000003c8
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_2F_T			0x000003cc
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_2F_S			0x000003d0
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_2F_T			0x000003d4
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_2F_S			0x000003d8
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_2F_T			0x000003dc
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_3F_X			0x00000400
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_3F_Y			0x00000404
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_3F_Z			0x00000408
#define NV50_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_X			0x00000420
#define NV50_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_Y			0x00000424
#define NV50_TCL_PRIMITIVE_3D_VERTEX_NOR_3F_Z			0x00000428
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_3F_R			0x00000430
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_3F_G			0x00000434
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_3F_B			0x00000438
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_R			0x00000440
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_G			0x00000444
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL2_3F_B			0x00000448
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_4F_X			0x00000500
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_4F_Y			0x00000504
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_4F_Z			0x00000508
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_4F_W			0x0000050c
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_4F_R			0x00000530
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_4F_G			0x00000534
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_4F_B			0x00000538
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_4F_A			0x0000053c
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_S			0x00000580
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_T			0x00000584
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_R			0x00000588
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_4F_Q			0x0000058c
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_S			0x00000590
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_T			0x00000594
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_R			0x00000598
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_4F_Q			0x0000059c
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_S			0x000005a0
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_T			0x000005a4
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_R			0x000005a8
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_4F_Q			0x000005ac
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_S			0x000005b0
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_T			0x000005b4
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_R			0x000005b8
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_4F_Q			0x000005bc
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_2I			0x000006a0
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_2I			0x000006a4
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_2I			0x000006a8
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_2I			0x000006ac
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_4I_XY			0x00000700
#define NV50_TCL_PRIMITIVE_3D_VERTEX_POS_4I_ZW			0x00000704
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_ST			0x00000740
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX0_4I_RQ			0x00000744
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_ST			0x00000748
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX1_4I_RQ			0x0000074c
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_4I_ST			0x00000750
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX2_4I_RQ			0x00000754
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_4I_ST			0x00000758
#define NV50_TCL_PRIMITIVE_3D_VERTEX_TX3_4I_RQ			0x0000075c
#define NV50_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_XY			0x00000790
#define NV50_TCL_PRIMITIVE_3D_VERTEX_NOR_3I_Z			0x00000794
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL_4I			0x0000088c
#define NV50_TCL_PRIMITIVE_3D_VERTEX_COL2_3I			0x00000890
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_UNK0_X			0x00000a00
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_UNK0_Y			0x00000a04
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_UNK0_Z			0x00000a08
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_UNK1_X			0x00000a0c
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_UNK1_Y			0x00000a10
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_UNK1_Z			0x00000a14
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_0			0x00000c00
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_DIMS_1			0x00000c04
#define NV50_TCL_PRIMITIVE_3D_DEPTH_RANGE_NEAR			0x00000c08
#define NV50_TCL_PRIMITIVE_3D_DEPTH_RANGE_FAR			0x00000c0c
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_CLIP_HORIZ(n)		(0x0000d00+(n<<3))
#define NV50_TCL_PRIMITIVE_3D_VIEWPORT_CLIP_VERT(n)		(0x0000d04+(n<<3))
#define NV50_TCL_PRIMITIVE_3D_VERTEX_BUFFER_FIRST		0x00000d74
#define NV50_TCL_PRIMITIVE_3D_VERTEX_BUFFER_COUNT		0x00000d78
#define NV50_TCL_PRIMITIVE_3D_CLEAR_COLOR_R			0x00000d80
#define NV50_TCL_PRIMITIVE_3D_CLEAR_COLOR_G			0x00000d84
#define NV50_TCL_PRIMITIVE_3D_CLEAR_COLOR_B			0x00000d88
#define NV50_TCL_PRIMITIVE_3D_CLEAR_COLOR_A			0x00000d8c
#define NV50_TCL_PRIMITIVE_3D_CLEAR_DEPTH			0x00000d90
#define NV50_TCL_PRIMITIVE_3D_CLEAR_STENCIL			0x00000da0
#define NV50_TCL_PRIMITIVE_3D_POLYGON_MODE_FRONT		0x00000dac
#define NV50_TCL_PRIMITIVE_3D_POLYGON_MODE_BACK			0x00000db0
#define NV50_TCL_PRIMITIVE_3D_POLYGON_SMOOTH_ENABLE		0x00000db4
#define NV50_TCL_PRIMITIVE_3D_POLYGON_OFFSET_POINT_ENABLE	0x00000dc0
#define NV50_TCL_PRIMITIVE_3D_POLYGON_OFFSET_LINE_ENABLE	0x00000dc4
#define NV50_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FILL_ENABLE	0x00000dc8
#define NV50_TCL_PRIMITIVE_3D_SCISSOR_WIDTH_XPOS		0x00000e04
#define NV50_TCL_PRIMITIVE_3D_SCISSOR_HEIGHT_YPOS		0x00000e08
#define NV50_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_ID		0x00000f00
#define NV50_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_X			0x00000f04
#define NV50_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_Y			0x00000f08
#define NV50_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_Z			0x00000f0c
#define NV50_TCL_PRIMITIVE_3D_VP_UPLOAD_CONST_W			0x00000f10
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_FUNC_REF		0x00000f54
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_MASK		0x00000f58
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_FUNC_MASK		0x00000f5c
#define NV50_TCL_PRIMITIVE_3D_DEPTH_TEST_ENABLE			0x000012cc
#define NV50_TCL_PRIMITIVE_3D_SHADE_MODEL			0x000012d4
#define NV50_TCL_PRIMITIVE_3D_DEPTH_WRITE_ENABLE		0x000012e8
#define NV50_TCL_PRIMITIVE_3D_ALPHA_FUNC_ENABLE			0x000012ec
#define NV50_TCL_PRIMITIVE_3D_DEPTH_FUNC			0x0000130c
#define NV50_TCL_PRIMITIVE_3D_ALPHA_FUNC_REF			0x00001310
#define NV50_TCL_PRIMITIVE_3D_ALPHA_FUNC_FUNC			0x00001314
#define NV50_TCL_PRIMITIVE_3D_BLEND_COLOR_R			0x0000131c
#define NV50_TCL_PRIMITIVE_3D_BLEND_COLOR_G			0x00001320
#define NV50_TCL_PRIMITIVE_3D_BLEND_COLOR_B			0x00001324
#define NV50_TCL_PRIMITIVE_3D_BLEND_COLOR_A			0x00001328
#define NV50_TCL_PRIMITIVE_3D_BLEND_EQUATION_RGB		0x00001340
#define NV50_TCL_PRIMITIVE_3D_BLEND_FUNC_SRC_RGB		0x00001344
#define NV50_TCL_PRIMITIVE_3D_BLEND_FUNC_DST_RGB		0x00001348
#define NV50_TCL_PRIMITIVE_3D_BLEND_EQUATION_ALPHA		0x0000134c
#define NV50_TCL_PRIMITIVE_3D_BLEND_FUNC_SRC_ALPHA		0x00001350
#define NV50_TCL_PRIMITIVE_3D_BLEND_FUNC_DST_ALPHA		0x00001358
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_ENABLE		0x00001380
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_OP_FAIL		0x00001384
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_OP_ZFAIL		0x00001388
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_OP_ZPASS		0x0000138c
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_FUNC_FUNC		0x00001390
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_FUNC_REF  		0x00001394
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_MASK			0x00001398
#define NV50_TCL_PRIMITIVE_3D_STENCIL_BACK_FUNC_MASK		0x0000139c
#define NV50_TCL_PRIMITIVE_3D_LINE_WIDTH			0x000013b0
#define NV50_TCL_PRIMITIVE_3D_POINT_SIZE			0x00001518
#define NV50_TCL_PRIMITIVE_3D_POLYGON_OFFSET_FACTOR		0x0000156c
#define NV50_TCL_PRIMITIVE_3D_LINE_SMOOTH_ENABLE		0x00001570
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_ENABLE		0x00001594
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_OP_FAIL		0x00001598
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_OP_ZFAIL		0x0000159c
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_OP_ZPASS		0x000015a0
#define NV50_TCL_PRIMITIVE_3D_STENCIL_FRONT_FUNC_FUNC		0x000015a4
#define NV50_TCL_PRIMITIVE_3D_POLYGON_OFFSET_UNITS		0x000015bc
#define NV50_TCL_PRIMITIVE_3D_VERTEX_BEGIN			0x000015dc
#define NV50_TCL_PRIMITIVE_3D_VERTEX_END			0x000015e0
#define NV50_TCL_PRIMITIVE_3D_VERTEX_DATA			0x00001640
#define NV50_TCL_PRIMITIVE_3D_LINE_STIPPLE_ENABLE		0x0000166c
#define NV50_TCL_PRIMITIVE_3D_LINE_STIPPLE_PATTERN		0x00001680
#define NV50_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_ENABLE		0x0000168c
#define NV50_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_PATTERN(n)	(0x00001700+(n<<2))
#define NV50_TCL_PRIMITIVE_3D_POLYGON_STIPPLE_PATTERN__SIZE	32
#define NV50_TCL_PRIMITIVE_3D_CULL_FACE_ENABLE			0x00001918
#define NV50_TCL_PRIMITIVE_3D_FRONT_FACE			0x0000191c
#define NV50_TCL_PRIMITIVE_3D_CULL_FACE				0x00001920
#define NV50_TCL_PRIMITIVE_3D_LOGIC_OP_ENABLE			0x000019c4
#define NV50_TCL_PRIMITIVE_3D_LOGIC_OP_OP			0x000019c8
#define NV50_TCL_PRIMITIVE_3D_CLEAR_BUFFERS			0x000019d0
#define NV50_TCL_PRIMITIVE_3D_COLOR_MASK(n)			(0x00001a00+(n<<2))
#define NV50_TCL_PRIMITIVE_3D_COLOR_MASK__SIZE			8
